/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.views;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.math.stat.StatUtils;
import org.eclipse.recommenders.stats.rcp.events.CompletionEvent;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.interfaces.IPageContent;
import org.eclipse.recommenders.stats.rcp.ui.data.StatisticData;
import org.eclipse.recommenders.stats.rcp.ui.util.LabelHelperFactory;
import org.eclipse.recommenders.stats.rcp.ui.util.TableViewerFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class StatisticsView
implements IPageContent {
    private static long MAX_TIME_IN_COMPLETION = TimeUnit.MINUTES.toMillis(2L);
    private final Collection<CompletionEvent> okayEvents;
    private final Collection<CompletionEvent> appliedEvents;
    private final Collection<CompletionEvent> abortedEvents;
    private Composite container;
    private Composite parent;

    @Inject
    public StatisticsView(IDataPersistenceService persistenceService) {
        StatisticData statsData = StatisticData.create(persistenceService);
        this.okayEvents = statsData.getOkayEvents();
        this.appliedEvents = statsData.getAppliedEvents();
        this.abortedEvents = statsData.getAbortedEvents();
    }

    @Override
    public Composite createContent(Composite detailCmp) {
        this.parent = TableViewerFactory.createWrapperComposite(detailCmp);
        this.createWidgets(this.parent);
        this.createNumberOfCompletionEvents();
        this.createNumberOfKeystrokesSaved();
        this.createTimeSpent();
        return this.parent;
    }

    private void createWidgets(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout grid = new GridLayout(2, false);
        grid.marginHeight = 5;
        grid.horizontalSpacing = 0;
        grid.verticalSpacing = 0;
        this.container.setLayout((Layout)grid);
    }

    private void createNumberOfCompletionEvents() {
        int total = 0;
        for (CompletionEvent e : this.okayEvents) {
            total += e.numberOfProposals;
        }
        LabelHelperFactory.createTwoSeparatorLabel(this.container);
        int completedInPercent = this.calculatePercentData(this.appliedEvents);
        new Label(this.container, 0).setText("Number of times code completion triggered: ");
        LabelHelperFactory.createLabelWithColor(this.container, MessageFormat.format("{0}", this.okayEvents.size()));
        int abortedInPercent = this.calculatePercentData(this.abortedEvents);
        new Label(this.container, 0).setText("Number of concluded completions: ");
        LabelHelperFactory.createLabelWithColor(this.container, MessageFormat.format("{0} ({1}%)", this.appliedEvents.size(), completedInPercent));
        new Label(this.container, 0).setText("Number of aborted completions: ");
        LabelHelperFactory.createLabelWithColor(this.container, MessageFormat.format("{0} ({1}%)", this.abortedEvents.size(), abortedInPercent));
        new Label(this.container, 0).setText("Number of proposals offered by code completion: ");
        LabelHelperFactory.createLabelWithColor(this.container, MessageFormat.format("{0}", total));
    }

    private void createNumberOfKeystrokesSaved() {
        double[] strokes = new double[this.appliedEvents.size()];
        int i = 0;
        for (CompletionEvent e : this.appliedEvents) {
            int prefix = e.prefix == null ? 0 : e.prefix.length();
            int completionLength = e.completion == null ? 0 : e.completion.length();
            int saved = Math.max(0, completionLength - prefix);
            strokes[i++] = saved;
        }
        Double total = StatUtils.sum((double[])strokes);
        new Label(this.container, 0).setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.createFilledLabel("Keystrokes saved by using code completion");
        new Label(this.container, 0).setText("Total number: ");
        LabelHelperFactory.createLabelWithColor(this.container, MessageFormat.format("{0}", total.isNaN() ? 0.0 : total));
        Double mean = StatUtils.mean((double[])strokes);
        new Label(this.container, 0).setText("Average number:");
        LabelHelperFactory.createLabelWithColor(this.container, MessageFormat.format("{0,number,#.##}", mean.isNaN() ? 0.0 : mean));
    }

    private void createTimeSpent() {
        double[] spentApplied = this.computeTimeSpentInCompletion(this.appliedEvents);
        long totalApplied = Math.round(StatUtils.sum((double[])spentApplied));
        long meanApplied = Math.round(StatUtils.mean((double[])spentApplied));
        double[] spentAborted = this.computeTimeSpentInCompletion(this.abortedEvents);
        long totalAborted = Math.round(StatUtils.sum((double[])spentAborted));
        long meanAborted = Math.round(StatUtils.mean((double[])spentAborted));
        new Label(this.container, 0).setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.createFilledLabel("Total Time spent in completion window on");
        new Label(this.container, 0).setText("Concluded sessions:");
        LabelHelperFactory.createLabelWithColor(this.container, MessageFormat.format("{0}", this.toTimeString(totalApplied)));
        new Label(this.container, 0).setText("Aborted sessions:");
        LabelHelperFactory.createLabelWithColor(this.container, MessageFormat.format("{0}", this.toTimeString(totalAborted)));
        new Label(this.container, 0).setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.createFilledLabel("Average time spent in completion window per");
        new Label(this.container, 0).setText("Concluded sessions:");
        LabelHelperFactory.createLabelWithColor(this.container, MessageFormat.format("{0}", meanApplied));
        new Label(this.container, 0).setText("Aborted sessions:");
        LabelHelperFactory.createLabelWithColor(this.container, MessageFormat.format("{0}", meanAborted));
    }

    private int calculatePercentData(Collection<CompletionEvent> list) {
        if (this.okayEvents.size() == 0) {
            return this.okayEvents.size();
        }
        double division = (double)list.size() / (double)this.okayEvents.size() * 100.0;
        return (int)Math.round(division);
    }

    private void createFilledLabel(String text) {
        Label label2 = new Label(this.container, 0);
        label2.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        label2.setText(text);
    }

    private String toTimeString(long time) {
        return String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(time), TimeUnit.MILLISECONDS.toSeconds(time) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(time)));
    }

    private double[] computeTimeSpentInCompletion(Collection<CompletionEvent> events) {
        double[] spent = new double[events.size()];
        int i = 0;
        for (CompletionEvent e : events) {
            long ms = e.sessionEnded - e.sessionStarted;
            if (ms > MAX_TIME_IN_COMPLETION) {
                ms = MAX_TIME_IN_COMPLETION;
            }
            spent[i++] = ms;
        }
        return spent;
    }
}

