/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.stats.rcp.ui.views;

import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.recommenders.rcp.utils.TableSortConfigurator;
import org.eclipse.recommenders.stats.rcp.interfaces.IPageContent;
import org.eclipse.recommenders.stats.rcp.model.WorkspaceProjectType;
import org.eclipse.recommenders.stats.rcp.ui.data.WorkspaceProjectData;
import org.eclipse.recommenders.stats.rcp.ui.util.LabelHelperFactory;
import org.eclipse.recommenders.stats.rcp.ui.util.TableSorters;
import org.eclipse.recommenders.stats.rcp.ui.util.TableViewerFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WorkspaceProjectView
implements IPageContent {
    private Label numberOfProjectsDesc;
    private Label sizeOfProjectsDesc;
    private Label projectNumberLabel;
    private Label projectSizeLabel;
    private TableViewer viewer;
    private Label counterLabel;

    @Override
    public Composite createContent(Composite detailParent) {
        Composite parent = TableViewerFactory.createWrapperComposite(detailParent);
        Composite labelCmp = this.createWrapper(parent);
        LabelHelperFactory.createTwoSeparatorLabel(labelCmp);
        this.numberOfProjectsDesc = new Label(labelCmp, 0);
        this.numberOfProjectsDesc.setText("Loading Data from Workspace, please wait ...");
        this.projectNumberLabel = LabelHelperFactory.createLabelWithColor(labelCmp);
        this.sizeOfProjectsDesc = new Label(labelCmp, 0);
        this.sizeOfProjectsDesc.setText("");
        this.projectSizeLabel = LabelHelperFactory.createLabelWithColor(labelCmp);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        TableColumnLayout layout = TableViewerFactory.createTableColumnLayout(comp);
        this.viewer = TableViewerFactory.createVirtualTableViewer(comp);
        TableViewerColumn nameCol = TableViewerFactory.createColumn("Name", this.viewer, 80, layout, 30, 0x1000000);
        TableViewerColumn typeCol = TableViewerFactory.createColumn("Type", this.viewer, 60, layout, 15, 0x1000000);
        TableViewerColumn filesCol = TableViewerFactory.createColumn("Files", this.viewer, 30, layout, 10, 0x1000000);
        TableViewerColumn sizeCol = TableViewerFactory.createColumn("Size", this.viewer, 30, layout, 10, 0x1000000);
        TableSortConfigurator.newConfigurator((TableViewer)this.viewer, (IAction)new Action(){

            public void run() {
                WorkspaceProjectView.this.viewer.refresh();
            }
        }).add(nameCol.getColumn(), TableSorters.WorkspaceProjects.NAME_COMPARATOR).add(typeCol.getColumn(), TableSorters.WorkspaceProjects.TYPE_COMPARATOR).add(filesCol.getColumn(), TableSorters.WorkspaceProjects.COUNT_COMPARATOR).add(sizeCol.getColumn(), TableSorters.WorkspaceProjects.SIZE_COMPARATOR).initialize(sizeCol.getColumn(), 1024).configure();
        TableViewerFactory.addMenu(this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkspaceProjectLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.counterLabel = LabelHelperFactory.createCounter(parent, 0);
        this.startProjectCollectorJob();
        return parent;
    }

    private void startProjectCollectorJob() {
        Job findFilesJob = new Job("Collect all Projects"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Collect Projects from Workspace", -1);
                WorkspaceProjectData workspaceData = new WorkspaceProjectData();
                List<WorkspaceProjectType> allProjects = workspaceData.readAllProjects();
                this.updateUI(workspaceData, allProjects);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            private void updateUI(final WorkspaceProjectData workspaceData, final List<WorkspaceProjectType> allProjects) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkspaceProjectView.this.numberOfProjectsDesc.setText("Total Number of all Projects: ");
                        WorkspaceProjectView.this.sizeOfProjectsDesc.setText("File Size of these Projects: ");
                        String fileSize = FileUtils.byteCountToDisplaySize((long)workspaceData.getTotalSize());
                        WorkspaceProjectView.this.projectNumberLabel.setText(Integer.toString(workspaceData.getTotalProjects()));
                        WorkspaceProjectView.this.projectSizeLabel.setText(fileSize);
                        WorkspaceProjectView.this.projectNumberLabel.getParent().pack();
                        WorkspaceProjectView.this.viewer.setInput((Object)allProjects);
                        LabelHelperFactory.update(WorkspaceProjectView.this.counterLabel, allProjects.size());
                    }
                });
            }
        };
        findFilesJob.setPriority(20);
        findFilesJob.schedule();
    }

    private Composite createWrapper(Composite parent) {
        Composite labelCmp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        labelCmp.setLayout((Layout)layout);
        labelCmp.setLayoutData((Object)new GridData(768));
        return labelCmp;
    }

    private class WorkspaceProjectLabelProvider
    extends StyledCellLabelProvider {
        private WorkspaceProjectLabelProvider() {
        }

        public void update(ViewerCell cell) {
            StyledString cellText = new StyledString();
            WorkspaceProjectType workspaceProject = (WorkspaceProjectType)cell.getElement();
            switch (cell.getColumnIndex()) {
                case 0: {
                    cellText.append(workspaceProject.getName());
                    break;
                }
                case 1: {
                    cellText.append(workspaceProject.getType());
                    break;
                }
                case 2: {
                    cellText.append(workspaceProject.getFileCount(), StyledString.COUNTER_STYLER);
                    break;
                }
                case 3: {
                    cellText.append(FileUtils.byteCountToDisplaySize((long)workspaceProject.getBytes()));
                }
            }
            cell.setText(cellText.toString());
            cell.setStyleRanges(cellText.getStyleRanges());
        }
    }
}

