/**
 * Copyright (c) 2014 Akif Etkue.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Akif Etkue - Initial API and implementation
 */
package org.eclipse.recommenders.stats.charts.rcp.charts;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;

import com.google.common.base.Preconditions;

public class BarChartFactory {

    public static Chart create(String title, String barTitle, String[] namesForSeries, Double[] valuesForSeries) {

        Preconditions.checkNotNull(title);
        Preconditions.checkNotNull(namesForSeries);
        Preconditions.checkNotNull(valuesForSeries);
        Preconditions.checkArgument(namesForSeries.length == valuesForSeries.length, "check array length");

        ChartWithAxes barChart = ChartWithAxesImpl.create();
        barChart.getBlock().setBackground(ColorDefinitionImpl.WHITE());
        barChart.getBlock().getOutline().setVisible(false);
        Plot plot = barChart.getPlot();
        plot.getOutline().setVisible(false);
        barChart.getTitle().getLabel().getCaption().setValue(title);

        if (namesForSeries.length == 0 || valuesForSeries.length == 0) {
            barChart.getTitle().getLabel().getCaption().setValue("No Data Available Yet");
        }

        Axis xAxis = barChart.getPrimaryBaseAxes()[0];
        xAxis.setType(AxisType.TEXT_LITERAL);
        xAxis.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        xAxis.getOrigin().setType(IntersectionType.VALUE_LITERAL);

        Axis yAxis = barChart.getPrimaryOrthogonalAxis(xAxis);
        yAxis.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        yAxis.setType(AxisType.LINEAR_LITERAL);
        yAxis.getScale().setMin(NumberDataElementImpl.create(0));

        SampleData sampleData = DataFactory.eINSTANCE.createSampleData();
        sampleData.getBaseSampleData().add(DataFactory.eINSTANCE.createBaseSampleData());

        sampleData.getOrthogonalSampleData().add(DataFactory.eINSTANCE.createOrthogonalSampleData());
        barChart.setSampleData(sampleData);

        Series category = SeriesImpl.create();
        category.setDataSet(TextDataSetImpl.create(namesForSeries));
        SeriesDefinition seriesX = SeriesDefinitionImpl.create();
        xAxis.getSeriesDefinitions().add(seriesX);
        seriesX.getSeries().add(category);

        BarSeries barSeries = (BarSeries) BarSeriesImpl.create();
        barSeries.setDataSet(NumberDataSetImpl.create(valuesForSeries));
        barSeries.setSeriesIdentifier(barTitle);
        barSeries.getLabel().setVisible(true);
        barSeries.setLabelPosition(Position.INSIDE_LITERAL);
        SeriesDefinition seriesY = SeriesDefinitionImpl.create();
        seriesY.getSeriesPalette().shift(-1);
        yAxis.getSeriesDefinitions().add(seriesY);
        seriesY.getSeries().add(barSeries);

        return barChart;
    }
}
