/**
 * Copyright (c) 2014 Akif Etkue.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Akif Etkue - Initial API and implementation
 */
package org.eclipse.recommenders.stats.charts.rcp.charts;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.recommenders.stats.charts.rcp.renderer.AbstractChartPage;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.ui.data.StatisticData;

import com.google.inject.Inject;

public class CodeCompletionChart extends AbstractChartPage {

    private final IDataPersistenceService service;

    @Inject
    public CodeCompletionChart(IDataPersistenceService service) {
        this.service = service;
    }

    @Override
    public final Chart createChart() {
        String title = "Number of Times Code Completion Triggered";
        StatisticData statsData = StatisticData.create(service);
        double concludedCompletions = statsData.getOkayEvents().size();
        double abortedCompletions = statsData.getAbortedEvents().size();
        String[] names = new String[] { "Concluded Completions", "Aborted Completions" };
        Double[] values = new Double[] { concludedCompletions, abortedCompletions };

        if (isNoDataAvailable(concludedCompletions, abortedCompletions)) {
            return PieChartFactory.create(title, new String[] {}, new Double[] {});
        }

        return PieChartFactory.create(title, names, values);
    }

    private boolean isNoDataAvailable(double concludedCompletions, double abortedCompletions) {
        return concludedCompletions == 0.0 && abortedCompletions == 0.0;
    }
}
