/**
 * Copyright (c) 2014 Akif Etkue.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Akif Etkue - Initial API and implementation
 */
package org.eclipse.recommenders.stats.charts.rcp.charts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.recommenders.stats.charts.rcp.renderer.AbstractChartPage;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.ui.data.WeekDays;
import org.eclipse.recommenders.stats.rcp.ui.data.WorkbenchData;

import com.google.inject.Inject;

public class EclipseActivityChart extends AbstractChartPage {

    private final IDataPersistenceService service;

    @Inject
    public EclipseActivityChart(IDataPersistenceService service) {
        this.service = service;
    }

    @Override
    public Chart createChart() {
        List<String> dayList = new ArrayList<String>();
        List<Double> numberList = new ArrayList<Double>();
        Map<WeekDays, Long> data = WorkbenchData.create(service).getHoursForWeekdays();
        for (WeekDays day : data.keySet()) {
            if (data.get(day) != null) {
                double formatHours = (double) data.get(day) / 3600000L;
                Double hoursPerDay = Math.round(formatHours * 100) / 100d;

                dayList.add(day.getDay());
                numberList.add(hoursPerDay);
            }
        }

        String[] names = dayList.toArray(new String[dayList.size()]);
        Double[] values = numberList.toArray(new Double[numberList.size()]);

        return BarChartFactory.create("Eclipse Weekday Performance", "Hours per Day", names, values);
    }
}
