/**
 * Copyright (c) 2013 Timur Achmetow.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Timur Achmetow - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp;

import javax.inject.Inject;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.ui.DeveloperActivityDialog;
import org.eclipse.ui.PlatformUI;

public class StatisticsDialogHandler extends AbstractHandler {

    private final IDataPersistenceService persistenceService;

    @Inject
    public StatisticsDialogHandler(IDataPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        new DeveloperActivityDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), persistenceService).open();
        return null;
    }
}
