/**
 * Copyright (c) 2013 Timur Achmetow.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Timur Achmetow - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.events;

import javax.inject.Inject;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.recommenders.stats.rcp.interfaces.IDataPersistenceService;
import org.eclipse.recommenders.stats.rcp.model.TriggeredCommandObject;
import org.eclipse.recommenders.stats.rcp.persistence.Constants;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class TriggeredCommandCollector implements IStartup, IExecutionListener {

    private final IDataPersistenceService persistenceService;

    @Inject
    public TriggeredCommandCollector(IDataPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public void earlyStartup() {
        ICommandService commandService = (ICommandService) PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        if (commandService != null) {
            commandService.addExecutionListener(this);
        }
    }

    @Override
    public void preExecute(String commandId, ExecutionEvent event) {
        TriggeredCommandObject triggeredCommand = new TriggeredCommandObject(commandId, System.currentTimeMillis());
        persistenceService.record(triggeredCommand, Constants.TRIGGERED_COMMANDS_CHANNEL);
    }

    @Override
    public void postExecuteSuccess(String commandId, Object returnValue) {
        // empty
    }

    @Override
    public void postExecuteFailure(String commandId, ExecutionException exception) {
        // empty
    }

    @Override
    public void notHandled(String commandId, NotHandledException exception) {
        // empty
    }
}
