/**
 * Copyright (c) 2013 Timur Achmetow.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Timur Achmetow - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.model;

import java.util.Date;

public class WorkbenchSession {

    private final Date sessionStarted;
    private final Date sessionEnded;

    public WorkbenchSession(long sessionStarted, long sessionEnded) {
        this.sessionStarted = new Date(sessionStarted);
        this.sessionEnded = new Date(sessionEnded);
    }

    public Date getStart() {
        return sessionStarted;
    }

    public Date getEnd() {
        return sessionEnded;
    }

    @Override
    public String toString() {
        return "Session started: " + sessionStarted + " and Ended: " + sessionEnded;
    }
}
