/**
 * Copyright (c) 2014 Akif Etkue.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Akif Etkue - Initial API and implementation
 */
package org.eclipse.recommenders.stats.rcp.ui.util;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.recommenders.stats.rcp.interfaces.ICategoryChildItem;
import org.eclipse.recommenders.stats.rcp.interfaces.ICategoryItem;

import com.ibm.icu.text.Collator;

public class TreeViewerSorter extends ViewerSorter {

    @Override
    public int compare(Viewer viewer, Object first, Object second) {
        Collator collator = Collator.getInstance();
        if (first instanceof ICategoryItem) {
            ICategoryItem item1 = (ICategoryItem) first;
            ICategoryItem item2 = (ICategoryItem) second;
            return collator.compare(item1.getName(), item2.getName());
        } else if (first instanceof ICategoryChildItem) {
            ICategoryChildItem item1 = (ICategoryChildItem) first;
            ICategoryChildItem item2 = (ICategoryChildItem) second;
            return collator.compare(item1.getName(), item2.getName());
        }
        return super.compare(viewer, first, second);
    }
}
