/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.factor.arraywrapper;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.recommenders.internal.jayes.util.ArrayUtils;
import org.eclipse.recommenders.jayes.factor.arraywrapper.IArrayWrapper;

public class DoubleArrayWrapper
implements IArrayWrapper {
    private double[] array;

    public DoubleArrayWrapper(double ... array) {
        this.array = array;
    }

    @Override
    public void setArray(double ... array) {
        this.array = array;
    }

    @Override
    public void setArray(float ... array) {
        this.setArray(ArrayUtils.toDoubleArray(array));
    }

    @Override
    public double[] toDoubleArray() {
        return this.array;
    }

    @Override
    public float[] toFloatArray() {
        return ArrayUtils.toFloatArray(this.array);
    }

    @Override
    public void set(int index, double d) {
        this.array[index] = d;
    }

    @Override
    public void set(int index, float d) {
        this.set(index, (double)d);
    }

    @Override
    public void mulAssign(int index, double d) {
        int n = index;
        this.array[n] = this.array[n] * d;
    }

    @Override
    public void mulAssign(int index, float d) {
        int n = index;
        this.array[n] = this.array[n] * (double)d;
    }

    @Override
    public void mulAssign(int index, IArrayWrapper arg, int argIndex) {
        int n = index;
        this.array[n] = this.array[n] * arg.getDouble(argIndex);
    }

    @Override
    public void addAssign(int index, double d) {
        int n = index;
        this.array[n] = this.array[n] + d;
    }

    @Override
    public void addAssign(int index, float d) {
        int n = index;
        this.array[n] = this.array[n] + (double)d;
    }

    @Override
    public void addAssign(int index, IArrayWrapper arg, int argIndex) {
        int n = index;
        this.array[n] = this.array[n] + arg.getDouble(argIndex);
    }

    @Override
    public double getDouble(int index) {
        return this.array[index];
    }

    @Override
    public float getFloat(int index) {
        return (float)this.array[index];
    }

    @Override
    public int length() {
        return this.array.length;
    }

    @Override
    public void copy(double ... array) {
        this.setArray((double[])array.clone());
    }

    @Override
    public void copy(float ... array) {
        this.setArray(ArrayUtils.toDoubleArray(array));
    }

    @Override
    public void copy(IArrayWrapper array) {
        this.copy(array.toDoubleArray());
    }

    @Override
    public void fill(double d) {
        Arrays.fill(this.array, d);
    }

    @Override
    public void fill(float d) {
        Arrays.fill(this.array, (double)d);
    }

    @Override
    public DoubleArrayWrapper clone() {
        try {
            DoubleArrayWrapper result = (DoubleArrayWrapper)super.clone();
            result.array = (double[])this.array.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void arrayCopy(IArrayWrapper src, int srcOffset, int destOffset, int length) {
        System.arraycopy(src.toDoubleArray(), srcOffset, this.array, destOffset, length);
    }

    @Override
    public void newArray(int capacity) {
        this.array = new double[capacity];
    }

    @Override
    public int sizeOfElement() {
        return 8;
    }

    @Override
    public Iterator<Number> iterator() {
        return new Iterator<Number>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DoubleArrayWrapper.this.array.length;
            }

            @Override
            public Number next() {
                if (this.index >= DoubleArrayWrapper.this.array.length) {
                    throw new NoSuchElementException();
                }
                return DoubleArrayWrapper.this.array[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

