/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp.utils;

import java.util.UUID;
import org.eclipse.core.databinding.conversion.Converter;

public class DatabindingConverters {

    public static class EnumToBooleanConverter<T extends Enum<T>>
    extends Converter {
        private final T[] trueValues;

        @SafeVarargs
        public EnumToBooleanConverter(T ... trueValues) {
            super(Object.class, Boolean.class);
            this.trueValues = trueValues;
        }

        public Object convert(Object fromObject) {
            if (fromObject == null) {
                throw new IllegalArgumentException("Parameter 'fromObject' was null.");
            }
            T[] TArray = this.trueValues;
            int n = this.trueValues.length;
            int n2 = 0;
            while (n2 < n) {
                T trueValue = TArray[n2];
                if (trueValue == fromObject) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static class StringToUuidConverter
    extends Converter {
        public StringToUuidConverter() {
            super(String.class, UUID.class);
        }

        public Object convert(Object fromObject) {
            if (fromObject == null) {
                throw new IllegalArgumentException("Parameter 'fromObject' was null.");
            }
            String string = (String)fromObject;
            return UUID.fromString(string);
        }
    }
}

