/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.name.Names;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.IteratorService;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.ResetOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.commit.CommitHelper;
import org.eclipse.egit.ui.internal.commit.CommitJob;
import org.eclipse.egit.ui.internal.dialogs.CommitDialog;
import org.eclipse.egit.ui.internal.push.SimpleConfigurePushDialog;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.recommenders.injection.InjectionService;
import org.eclipse.recommenders.internal.snipmatch.rcp.BranchCheckoutFailureDialog;
import org.eclipse.recommenders.internal.snipmatch.rcp.DefaultGitSnippetRepositoryConfigurations;
import org.eclipse.recommenders.internal.snipmatch.rcp.Repositories;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.Messages;
import org.eclipse.recommenders.snipmatch.GitSnippetRepository;
import org.eclipse.recommenders.snipmatch.ISearchContext;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.SnippetRepositoryClosedEvent;
import org.eclipse.recommenders.snipmatch.rcp.SnippetRepositoryContentChangedEvent;
import org.eclipse.recommenders.snipmatch.rcp.SnippetRepositoryOpenedEvent;
import org.eclipse.recommenders.snipmatch.rcp.model.EclipseGitSnippetRepositoryConfiguration;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Uris;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class EclipseGitSnippetRepository
implements ISnippetRepository {
    private static final String SNIPPETS_DIR = "snippets/";
    private static final int COMMIT_MESSAGE_FIRST_LINE_LENGTH = 65;
    private static final int COMMIT_MESSAGE_LINE_LENGTH = 70;
    private final EventBus bus;
    private final GitSnippetRepository delegate;
    private volatile int timesOpened;
    private volatile boolean delegateOpen;
    private final Lock readLock;
    private final Lock writeLock;
    private volatile Job openJob = null;
    private final ISchedulingRule schedulingRule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private Set<String> notTracked;
    private Set<String> files;

    public EclipseGitSnippetRepository(String id, File basedir, URI fetchUri, URI pushUri, String pushBranchPrefix, EventBus bus) {
        this.bus = bus;
        this.delegate = new GitSnippetRepository(id, new File(basedir, Uris.mangle((URI)fetchUri)), fetchUri, pushUri, pushBranchPrefix);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    public void open() {
        this.writeLock.lock();
        try {
            ++this.timesOpened;
            if (this.timesOpened > 1) {
                return;
            }
            if (this.openJob == null && !this.delegateOpen) {
                this.openJob = new Job(Messages.JOB_NAME_OPENING_SNIPPET_REPOSITORY){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            EclipseGitSnippetRepository.this.delegate.open();
                            this.changeStateToOpen();
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        catch (GitSnippetRepository.GitUpdateException e) {
                            this.changeStateToOpen();
                            Status status = new Status(2, "org.eclipse.recommenders.snipmatch.rcp", MessageFormat.format(Messages.WARNING_FAILURE_TO_UPDATE_REPOSITORY, EclipseGitSnippetRepository.this.delegate.getRepositoryLocation(), e.getMessage()), (Throwable)e);
                            Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.recommenders.snipmatch.rcp")).log((IStatus)status);
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        catch (GitSnippetRepository.GitNoCurrentFormatBranchException e) {
                            this.changeStateToOpen();
                            Status status = new Status(2, "org.eclipse.recommenders.snipmatch.rcp", MessageFormat.format(Messages.WARNING_FAILURE_TO_CHECKOUT_CURRENT_BRANCH, "format-5", EclipseGitSnippetRepository.this.delegate.getRepositoryLocation(), e.getCheckoutVersion(), e.getMessage()), (Throwable)e);
                            Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.recommenders.snipmatch.rcp")).log((IStatus)status);
                            final Display display = Display.getDefault();
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    BranchCheckoutFailureDialog dialog = new BranchCheckoutFailureDialog(display.getActiveShell(), EclipseGitSnippetRepository.this.delegate.getRepositoryLocation(), "format-5", e.getCheckoutVersion());
                                    dialog.open();
                                }
                            });
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        catch (GitSnippetRepository.GitNoFormatBranchException e) {
                            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_OPEN_GIT_SNIPPET_REPOSITORY, (Throwable)e);
                            Status status = new Status(4, "org.eclipse.recommenders.snipmatch.rcp", MessageFormat.format(Messages.ERROR_NO_FORMAT_BRANCH, "format-5", EclipseGitSnippetRepository.this.delegate.getRepositoryLocation(), e.getMessage()), (Throwable)e);
                            Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.recommenders.snipmatch.rcp")).log((IStatus)status);
                            final Display display = Display.getDefault();
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    BranchCheckoutFailureDialog dialog = new BranchCheckoutFailureDialog(display.getActiveShell(), EclipseGitSnippetRepository.this.delegate.getRepositoryLocation(), "format-5");
                                    dialog.open();
                                }
                            });
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        catch (IOException e) {
                            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_OPEN_GIT_SNIPPET_REPOSITORY, (Throwable)e);
                            Status status = new Status(4, "org.eclipse.recommenders.snipmatch.rcp", MessageFormat.format(Messages.ERROR_FAILURE_TO_CLONE_REPOSITORY, EclipseGitSnippetRepository.this.delegate.getRepositoryLocation(), EclipseGitSnippetRepository.this.timesOpened, e.getMessage()), (Throwable)e);
                            Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.recommenders.snipmatch.rcp")).log((IStatus)status);
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        finally {
                            EclipseGitSnippetRepository.this.openJob = null;
                        }
                    }

                    private void changeStateToOpen() {
                        EclipseGitSnippetRepository.this.delegateOpen = true;
                        EclipseGitSnippetRepository.this.bus.post((Object)new SnippetRepositoryOpenedEvent(EclipseGitSnippetRepository.this));
                    }
                };
                this.openJob.schedule();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void close() throws IOException {
        block10: {
            this.writeLock.lock();
            try {
                if (this.timesOpened == 0) {
                    return;
                }
                if (this.timesOpened > 1) {
                    --this.timesOpened;
                    return;
                }
                if (this.timesOpened != 1) break block10;
                this.timesOpened = 0;
                if (this.openJob != null) {
                    try {
                        this.openJob.join();
                        this.openJob = null;
                    }
                    catch (InterruptedException e) {
                        Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_JOIN_OPEN_JOB, (Throwable)e);
                    }
                }
                this.delegate.close();
                this.delegateOpen = false;
                this.bus.post((Object)new SnippetRepositoryClosedEvent(this));
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public List<Recommendation<ISnippet>> search(ISearchContext context) {
        this.readLock.lock();
        try {
            if (!this.isOpen() || !this.delegateOpen) {
                List<Recommendation<ISnippet>> list = Collections.emptyList();
                return list;
            }
            List list = this.delegate.search(context);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<Recommendation<ISnippet>> search(ISearchContext context, int maxResults) {
        this.readLock.lock();
        try {
            if (!this.isOpen() || !this.delegateOpen) {
                List<Recommendation<ISnippet>> list = Collections.emptyList();
                return list;
            }
            List list = this.delegate.search(context, maxResults);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Subscribe
    public void onEvent(Repositories.SnippetRepositoryConfigurationChangedEvent e) throws IOException {
        this.close();
        this.open();
    }

    public String getRepositoryLocation() {
        this.readLock.lock();
        try {
            String string = this.delegate.getRepositoryLocation();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getId() {
        this.readLock.lock();
        try {
            String string = this.delegate.getId();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean hasSnippet(UUID uuid) {
        this.readLock.lock();
        try {
            if (!this.isOpen() || !this.delegateOpen) {
                return false;
            }
            boolean bl = this.delegate.hasSnippet(uuid);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean delete(UUID uuid) throws IOException {
        this.writeLock.lock();
        try {
            if (!this.isOpen() || !this.delegateOpen) {
                return false;
            }
            boolean deleted = this.delegate.delete(uuid);
            if (deleted) {
                this.bus.post((Object)new SnippetRepositoryContentChangedEvent(this));
            }
            boolean bl = deleted;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isDeleteSupported() {
        return this.delegate.isDeleteSupported();
    }

    private boolean isOpen() {
        return this.timesOpened > 0;
    }

    public void importSnippet(ISnippet snippet) throws IOException {
        this.writeLock.lock();
        try {
            Preconditions.checkState((boolean)this.isOpen(), (Object)Messages.ERROR_REPOSITORY_NOT_OPEN_YET);
            this.delegate.importSnippet(snippet);
            this.bus.post((Object)new SnippetRepositoryContentChangedEvent(this));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isImportSupported() {
        return this.delegate.isImportSupported();
    }

    public static ISnippetRepository createRepositoryInstance(EclipseGitSnippetRepositoryConfiguration config) {
        EventBus bus = (EventBus)InjectionService.getInstance().requestInstance(EventBus.class);
        File basedir = (File)InjectionService.getInstance().requestAnnotatedInstance(File.class, (Annotation)Names.named((String)"SNIPPET_REPOSITORY_BASEDIR"));
        URI uri = Uris.toUri((String)config.getUrl());
        URI pushUri = Uris.toUri((String)config.getPushUrl());
        return new EclipseGitSnippetRepository(config.getId(), basedir, uri, pushUri, config.getPushBranchPrefix(), bus);
    }

    public static BasicEList<SnippetRepositoryConfiguration> getDefaultConfiguration() {
        BasicEList result = new BasicEList();
        result.addAll(DefaultGitSnippetRepositoryConfigurations.fetchDefaultConfigurations());
        return result;
    }

    public boolean delete() {
        this.writeLock.lock();
        try {
            this.close();
            this.delegate.delete();
            return true;
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_DELETE_GIT_SNIPPET_REPOSITORY_ON_DISK, (Throwable)e);
            return false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean share(Collection<UUID> uuids) {
        this.writeLock.lock();
        try {
            ArrayList<ISnippet> snippets = new ArrayList<ISnippet>();
            for (UUID uuid : uuids) {
                ISnippet snippet = this.delegate.getSnippet(uuid);
                if (snippet == null) continue;
                snippets.add(snippet);
            }
            boolean bl = this.shareSnippets(snippets);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean shareSnippets(Collection<ISnippet> snippets) {
        if (snippets.isEmpty()) {
            return false;
        }
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        List<IResource> resources = this.toResource(snippets, workspace);
        IResource[] selectedResources = resources.toArray(new IResource[resources.size()]);
        boolean committed = this.commit(this.delegate.getGitRepo(), selectedResources, (IResource)workspace.getRoot(), snippets, shell);
        if (!committed) {
            return false;
        }
        this.push(this.delegate.getGitRepo(), shell);
        this.reset(workspace);
        return true;
    }

    private List<IResource> toResource(Collection<ISnippet> snippets, Workspace workspace) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (ISnippet snippet : snippets) {
            File snippetFile = this.delegate.getSnippetFile(snippet.getUuid());
            if (snippetFile == null) continue;
            Path location = new Path(snippetFile.getAbsolutePath());
            Resource file = workspace.newResource((IPath)location, 1);
            resources.add((IResource)file);
        }
        return resources;
    }

    public boolean isSharingSupported() {
        return true;
    }

    private boolean commit(Repository repo, IResource[] selectedResources, IResource workspace, Collection<ISnippet> snippets, Shell shell) {
        this.files = new HashSet<String>();
        IndexDiff indexDiff = null;
        try {
            indexDiff = this.buildIndexHeadDiffList(this.delegate.getGitRepo(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CREATING_INDEX_HEAD_DIFF, (Throwable)e, (Object[])new Object[]{this.delegate.getRepositoryLocation()});
            return false;
        }
        if (indexDiff == null) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CREATING_INDEX_HEAD_DIFF, (Object[])new Object[]{this.delegate.getRepositoryLocation()});
        }
        if (this.files.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.DIALOG_TITLE_SELECTION_NOT_SHAREABLE, (String)Messages.DIALOG_MESSAGE_NO_GIT_CHANGES_IN_SELECTION);
            return false;
        }
        HashSet<String> preselectedFiles = new HashSet<String>();
        this.getPreselectedFiles(selectedResources, preselectedFiles);
        if (preselectedFiles.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.DIALOG_TITLE_SELECTION_NOT_SHAREABLE, (String)Messages.DIALOG_MESSAGE_NO_GIT_CHANGES_IN_SELECTION);
            return false;
        }
        Collection<ISnippet> changedSnippets = this.getChangedSnippets(snippets, preselectedFiles);
        String commitMessage = this.getCommitMessage(changedSnippets);
        CommitDialog commitDialog = this.getCommitDialog(shell, indexDiff, preselectedFiles, commitMessage);
        return this.doCommit(commitDialog);
    }

    private IndexDiff buildIndexHeadDiffList(Repository repo, IProgressMonitor monitor) throws IOException, OperationCanceledException {
        monitor.beginTask(Messages.MONITOR_CALCULATING_DIFF, 1000);
        try {
            WorkingTreeIterator it = IteratorService.createInitialIterator((Repository)repo);
            if (it == null) {
                throw new OperationCanceledException();
            }
            IndexDiff indexDiff = new IndexDiff(repo, "HEAD", it);
            indexDiff.diff();
            HashSet<String> indexChanges = new HashSet<String>();
            HashSet<String> notIndexed = new HashSet<String>();
            this.notTracked = new HashSet<String>();
            this.includeList(indexDiff.getAdded(), indexChanges);
            this.includeList(indexDiff.getChanged(), indexChanges);
            this.includeList(indexDiff.getRemoved(), indexChanges);
            this.includeList(indexDiff.getMissing(), notIndexed);
            this.includeList(indexDiff.getModified(), notIndexed);
            this.includeList(indexDiff.getUntracked(), this.notTracked);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IndexDiff indexDiff2 = indexDiff;
            return indexDiff2;
        }
        finally {
            monitor.done();
        }
    }

    private void includeList(Set<String> added, Set<String> category) {
        for (String filename : added) {
            if (!this.files.contains(filename)) {
                this.files.add(filename);
            }
            category.add(filename);
        }
    }

    private void getPreselectedFiles(IResource[] selectedResources, Set<String> preselectedFiles) {
        for (String fileName : this.files) {
            URI uri = new File(this.delegate.getGitRepo().getWorkTree(), fileName).toURI();
            IResource[] iResourceArray = selectedResources;
            int n = selectedResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getFullPath().toFile().equals(new File(uri))) {
                    preselectedFiles.add(fileName);
                }
                ++n2;
            }
        }
    }

    private Collection<ISnippet> getChangedSnippets(Collection<ISnippet> snippets, final Set<String> preselectedFiles) {
        return Collections2.filter(snippets, (Predicate)new Predicate<ISnippet>(){

            public boolean apply(ISnippet input) {
                UUID uuid = input.getUuid();
                for (String preselectedFile : preselectedFiles) {
                    if (!preselectedFile.substring(EclipseGitSnippetRepository.SNIPPETS_DIR.length(), preselectedFile.length() - "json".length() - 1).equals(uuid.toString())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private String getCommitMessage(Collection<ISnippet> snippets) {
        StringBuilder sb = new StringBuilder();
        String header = "";
        if (snippets.size() == 1) {
            ISnippet snippet = snippets.iterator().next();
            header = MessageFormat.format("Snippet contribution: {0} - {1}", snippet.getName(), snippet.getDescription());
        } else {
            header = MessageFormat.format("This contributes {0} snippets", snippets.size());
        }
        sb.append(StringUtils.abbreviate((String)header, (int)65));
        sb.append(SystemUtils.LINE_SEPARATOR);
        sb.append(SystemUtils.LINE_SEPARATOR);
        for (ISnippet snippet : snippets) {
            String snippetDescription = snippet.getDescription();
            String line = "";
            line = org.eclipse.jgit.util.StringUtils.isEmptyOrNull((String)snippetDescription) ? " * " + snippet.getName() : " * " + snippet.getName() + " - " + snippet.getDescription();
            sb.append(StringUtils.abbreviate((String)line, (int)70));
            sb.append(SystemUtils.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private CommitDialog getCommitDialog(Shell shell, IndexDiff indexDiff, Set<String> preselectedFiles, String commitMessage) {
        CommitHelper commitHelper = new CommitHelper(this.delegate.getGitRepo());
        CommitDialog commitDialog = new CommitDialog(shell);
        commitDialog.setAmendAllowed(false);
        commitDialog.setFiles(this.delegate.getGitRepo(), this.files, indexDiff);
        commitDialog.setPreselectedFiles(preselectedFiles);
        commitDialog.setAuthor(commitHelper.getAuthor());
        commitDialog.setCommitter(commitHelper.getCommitter());
        commitDialog.setCommitMessage(commitMessage);
        return commitDialog;
    }

    private boolean doCommit(CommitDialog commitDialog) {
        CommitOperation commitOperation;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        boolean includeUntrackedPreference = preferenceStore.getBoolean("commit_dialog_include_untracked");
        try {
            preferenceStore.setValue("commit_dialog_include_untracked", true);
            if (commitDialog.open() != 0) {
                return false;
            }
        }
        finally {
            preferenceStore.setValue("commit_dialog_include_untracked", includeUntrackedPreference);
        }
        try {
            commitOperation = new CommitOperation(this.delegate.getGitRepo(), commitDialog.getSelectedFiles(), this.notTracked, commitDialog.getAuthor(), commitDialog.getCommitter(), commitDialog.getCommitMessage());
        }
        catch (CoreException e) {
            Activator.handleError((String)Messages.ERROR_COMMIT_FAILED, (Throwable)e, (boolean)true);
            return false;
        }
        commitOperation.setComputeChangeId(commitDialog.getCreateChangeId());
        commitOperation.setCommitAll(false);
        CommitJob commitJob = new CommitJob(this.delegate.getGitRepo(), commitOperation);
        commitJob.setRule(this.schedulingRule);
        commitJob.schedule();
        return true;
    }

    private void push(Repository repository, final Shell shell) {
        RemoteConfig config = SimpleConfigurePushDialog.getConfiguredRemote((Repository)repository);
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        final PushOperation push = new PushOperation(repository, config.getName(), false, timeout);
        push.setCredentialsProvider(GitSnippetRepository.getCredentialsProvider((URI)this.delegate.getPushUrl()));
        Job pushJob = new Job(Messages.JOB_NAME_PUSHING_SNIPPETS_TO_REMOTE_GIT_REPO){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    push.run(monitor);
                    PushOperationResult operationResult = push.getOperationResult();
                    Iterator iterator = operationResult.getURIs().iterator();
                    if (iterator.hasNext()) {
                        URIish uri = (URIish)iterator.next();
                        String errorMessage = operationResult.getErrorMessage(uri);
                        if (errorMessage == null) {
                            return Status.OK_STATUS;
                        }
                        return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", MessageFormat.format(Messages.ERROR_FAILURE_TO_PUSH_SNIPPETS_TO_REMOTE_GIT_REPO, errorMessage));
                    }
                    return Status.OK_STATUS;
                }
                catch (InvocationTargetException e) {
                    return new Status(4, "org.eclipse.recommenders.snipmatch.rcp", Messages.ERROR_EXCEPTION_WHILE_PUSHING_SNIPPETS_TO_REMOTE_GIT_REPO, (Throwable)e);
                }
            }
        };
        pushJob.setRule(this.schedulingRule);
        pushJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (event.getResult().isOK()) {
                            MessageDialog.openInformation((Shell)shell, (String)Messages.DIALOG_TITLE_GIT_PUSH_SUCCESSFUL, (String)Messages.DIALOG_MESSAGE_GIT_PUSH_SUCCESSFUL);
                        }
                    }
                });
            }
        });
        pushJob.schedule();
    }

    private void reset(Workspace workspace) {
        ResetOperation reset = new ResetOperation(this.delegate.getGitRepo(), "origin/format-5", ResetCommand.ResetType.MIXED){

            public ISchedulingRule getSchedulingRule() {
                return EclipseGitSnippetRepository.this.schedulingRule;
            }
        };
        JobUtil.scheduleUserJob((IEGitOperation)reset, (String)Messages.JOB_RESETTING_GIT_REPOSITORY, null);
    }
}

