/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.snipmatch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.Location;
import org.eclipse.recommenders.utils.Checks;

public class Snippet
implements ISnippet {
    public static final String FORMAT_VERSION = "format-5";
    private transient PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    @SerializedName(value="uuid")
    private UUID uuid;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="extraSearchTerms")
    private List<String> extraSearchTerms = new ArrayList<String>();
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();
    @SerializedName(value="code")
    private String code;
    @SerializedName(value="location")
    private Location location = Location.FILE;
    @SerializedName(value="filenameRestrictions")
    private List<String> filenameRestrictions = new ArrayList<String>();
    @SerializedName(value="dependencies")
    private Set<ProjectCoordinate> neededDependencies = new HashSet<ProjectCoordinate>();

    public Snippet() {
        this(UUID.randomUUID(), "", "", new ArrayList<String>(), new ArrayList<String>(), "", Location.NONE, new ArrayList<String>(), new HashSet<ProjectCoordinate>());
    }

    public Snippet(String code, Set<ProjectCoordinate> dependencies) {
        this(UUID.randomUUID(), "", "", new ArrayList<String>(), new ArrayList<String>(), code, Location.NONE, new ArrayList<String>(), dependencies);
    }

    public Snippet(UUID uuid, String name, String description, List<String> extraSearchTerms, List<String> tags, String code, Location location, List<String> filenameRestrictions, Set<ProjectCoordinate> neededDependencies) {
        Checks.ensureIsNotNull((Object)uuid);
        Checks.ensureIsNotNull((Object)name);
        Checks.ensureIsNotNull((Object)description);
        Checks.ensureIsNotNull(extraSearchTerms);
        Checks.ensureIsNotNull(tags);
        Checks.ensureIsNotNull((Object)code);
        Checks.ensureIsNotNull((Object)((Object)location));
        Checks.ensureIsNotNull(neededDependencies);
        this.uuid = uuid;
        this.name = name;
        this.description = description;
        this.extraSearchTerms = extraSearchTerms;
        this.tags = tags;
        this.code = code;
        this.location = location;
        this.filenameRestrictions = filenameRestrictions;
        this.neededDependencies = neededDependencies;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getExtraSearchTerms() {
        return ImmutableList.copyOf(this.extraSearchTerms);
    }

    @Override
    public List<String> getTags() {
        return ImmutableList.copyOf(this.tags);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public List<String> getFilenameRestrictions() {
        return this.filenameRestrictions;
    }

    @Override
    public Set<ProjectCoordinate> getNeededDependencies() {
        return ImmutableSet.copyOf(this.neededDependencies);
    }

    public void setCode(String code) {
        this.code = code;
        this.firePropertyChange("code", this.code, this.code);
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange("name", this.name, this.name);
    }

    public void setDescription(String description) {
        this.description = description;
        this.firePropertyChange("description", this.description, this.description);
    }

    public void setNeededDependencies(Set<ProjectCoordinate> neededDependencies) {
        this.neededDependencies = neededDependencies;
        this.firePropertyChange("dependencies", this.neededDependencies, this.neededDependencies);
    }

    public void setLocation(Location location) {
        this.location = location;
        this.firePropertyChange("location", (Object)this.location, (Object)this.location);
    }

    public void setFilenameRestrictions(List<String> filenameRestrictions) {
        this.filenameRestrictions = filenameRestrictions;
        this.firePropertyChange("filenameRestrictions", this.filenameRestrictions, this.filenameRestrictions);
    }

    public void setExtraSearchTerms(List<String> extraSearchTerms) {
        this.extraSearchTerms = extraSearchTerms;
        this.firePropertyChange("extraSearchTerms", this.extraSearchTerms, this.extraSearchTerms);
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
        this.firePropertyChange("tags", this.tags, this.tags);
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public static Snippet copy(ISnippet snippet) {
        return new Snippet(snippet.getUuid(), snippet.getName(), snippet.getDescription(), snippet.getExtraSearchTerms(), snippet.getTags(), snippet.getCode(), snippet.getLocation() != null ? snippet.getLocation() : Location.FILE, snippet.getFilenameRestrictions(), snippet.getNeededDependencies());
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

