/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.jayes.rcp;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class CPTDialog
extends Dialog {
    private NumberFormat numberFormat = new DecimalFormat("0.00###############");
    private BayesNode node;

    CPTDialog(Shell parentShell, BayesNode node) {
        super(parentShell);
        this.node = node;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        TableColumnLayout tableLayout = new TableColumnLayout();
        container.setLayout((Layout)tableLayout);
        final double[] p = this.node.getProbabilities();
        TableViewer v = new TableViewer(container);
        Table table = v.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewerColumn tcs = new TableViewerColumn(v, 131072);
        tcs.getColumn().setText("node \\ parents");
        tcs.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((CPTRow)element).outcomeName;
            }
        });
        tableLayout.setColumnData((Widget)tcs.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 50, false));
        int index = 0;
        for (BayesNode parentNode : this.node.getParents()) {
            for (String parentNodeOutcome : parentNode.getOutcomes()) {
                final int indexI = index++;
                TableViewerColumn tc = new TableViewerColumn(v, 131072);
                tc.getColumn().setText(parentNodeOutcome);
                tc.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        CPTRow data = (CPTRow)element;
                        return CPTDialog.this.numberFormat.format(data.probabilities[indexI]);
                    }
                });
                tableLayout.setColumnData((Widget)tc.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 50, true));
            }
        }
        if (this.node.getParents().isEmpty()) {
            TableViewerColumn tc = new TableViewerColumn(v, 131072);
            tc.getColumn().setText("prior");
            tableLayout.setColumnData((Widget)tc.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 50, true));
            tc.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    CPTRow data = (CPTRow)element;
                    return CPTDialog.this.numberFormat.format(data.probabilities[0]);
                }
            });
        }
        v.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                int outcomeCount = CPTDialog.this.node.getOutcomeCount();
                int lineLength = p.length / outcomeCount;
                Object[] res = new CPTRow[outcomeCount];
                int i = 0;
                while (i < outcomeCount) {
                    res[i] = new CPTRow(CPTDialog.this.node.getOutcomeName(i), new double[lineLength]);
                    ++i;
                }
                int copyIndex = 0;
                int i2 = 0;
                while (i2 < p.length) {
                    int j = 0;
                    while (j < outcomeCount) {
                        ((CPTRow)res[j]).probabilities[copyIndex] = p[i2 + j];
                        ++j;
                    }
                    ++copyIndex;
                    i2 += outcomeCount;
                }
                return res;
            }
        });
        v.setInput((Object)p);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    class CPTRow {
        public String outcomeName;
        public double[] probabilities;

        public CPTRow(String outcome, double[] probabilities) {
            this.outcomeName = outcome;
            this.probabilities = probabilities;
        }
    }
}

