/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;
import org.eclipse.swt.graphics.Image;

public class OverlayImageProposalProcessor
extends ProposalProcessor {
    private final Map<Image, Image> cache = Maps.newHashMap();
    private final ImageDescriptor overlay;
    private final int decorationCorner;

    public OverlayImageProposalProcessor(ImageDescriptor overlay, int decorationCorner) {
        this.overlay = overlay;
        this.decorationCorner = decorationCorner;
    }

    @Override
    public Image modifyImage(Image image) {
        Image newImage = this.cache.get(image);
        if (newImage == null) {
            DecorationOverlayIcon decorator = new DecorationOverlayIcon(image, this.overlay, this.decorationCorner);
            newImage = decorator.createImage();
            this.cache.put(image, newImage);
        }
        return newImage;
    }
}

