/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.annotations.Beta;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;
import org.eclipse.swt.graphics.Image;

@Beta
public class ProposalProcessorManager {
    private final Set<ProposalProcessor> processors = Sets.newLinkedHashSet();
    private final IProcessableProposal proposal;

    public ProposalProcessorManager(IProcessableProposal proposal) {
        this.proposal = proposal;
    }

    public void addProcessor(ProposalProcessor processor) {
        this.processors.add(processor);
    }

    public boolean prefixChanged(String prefix) {
        boolean keepProposal = false;
        int tmpRelevance = 0;
        for (ProposalProcessor p : this.processors) {
            keepProposal |= p.isPrefix(prefix);
            tmpRelevance += p.modifyRelevance();
        }
        this.proposal.setRelevance(tmpRelevance);
        return keepProposal;
    }

    public StyledString decorateStyledDisplayString(StyledString mutableStyledString) {
        for (ProposalProcessor p : this.processors) {
            p.modifyDisplayString(mutableStyledString);
        }
        return mutableStyledString;
    }

    public Image decorateImage(Image proposalImage) {
        Image img = proposalImage;
        for (ProposalProcessor p : this.processors) {
            img = p.modifyImage(img);
        }
        return img;
    }
}

