/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.testing;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.recommenders.utils.Throws;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class JarFileMockBuilder {
    private final JarFile jarFile = (JarFile)Mockito.mock(JarFile.class);
    private final List<JarEntry> mockedEntries = Lists.newLinkedList();

    public JarFile build() {
        Mockito.when(this.jarFile.entries()).thenAnswer((Answer)new Answer<Enumeration<JarEntry>>(){

            public Enumeration<JarEntry> answer(InvocationOnMock invocation) throws Throwable {
                return Collections.enumeration(JarFileMockBuilder.this.mockedEntries);
            }
        });
        return this.jarFile;
    }

    public void addEntry(String name, InputStream stream) {
        JarEntry entry = (JarEntry)Mockito.mock(JarEntry.class);
        Mockito.when((Object)entry.getName()).thenReturn((Object)name);
        Mockito.when((Object)this.jarFile.getEntry(name)).thenReturn((Object)entry);
        try {
            Mockito.when((Object)this.jarFile.getInputStream(entry)).thenReturn((Object)stream);
        }
        catch (IOException iOException) {
            Throws.throwUnreachable();
        }
        this.mockedEntries.add(entry);
    }
}

