/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.testing.rcp.completion.rules;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.recommenders.testing.rcp.completion.rules.TemporaryFile;
import org.eclipse.recommenders.testing.rcp.completion.rules.TemporaryWorkspace;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.Zips;

public class TemporaryProject {
    static final String BIN_FOLDER_NAME = "bin";
    static final String SRC_FOLDER_NAME = "src";
    static final String JAR_FOLDER_NAME = "jar";
    private final Set<TemporaryFile> temporaryFiles = Sets.newHashSet();
    private final IWorkspace workspace;
    private final String name;
    private final IProject project;
    private IJavaProject javaProject;

    TemporaryProject(TemporaryWorkspace ws, String name) {
        this.workspace = ws.getWorkspace();
        this.name = name;
        this.project = this.workspace.getRoot().getProject(name);
        this.createProject();
    }

    private void createProject() {
        IWorkspaceRunnable populate = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                this.createAndOpenProject(TemporaryProject.this.project);
                if (!this.hasJavaNature(TemporaryProject.this.project)) {
                    this.addJavaNature(TemporaryProject.this.project);
                    TemporaryProject.this.addToClasspath(JavaRuntime.getDefaultJREContainerEntry());
                    this.addSourcePackageFragmentRoot(TemporaryProject.this.project);
                }
            }

            private void createAndOpenProject(IProject project) throws CoreException {
                if (!project.exists()) {
                    project.create(null);
                }
                project.open(null);
            }

            private boolean hasJavaNature(IProject project) throws CoreException {
                IProjectDescription description = project.getDescription();
                Object[] natures = description.getNatureIds();
                return ArrayUtils.contains((Object[])natures, (Object)"org.eclipse.jdt.core.javanature");
            }

            private void addJavaNature(IProject project) throws CoreException {
                IProjectDescription description = project.getDescription();
                Object[] natures = description.getNatureIds();
                String[] newNatures = (String[])ArrayUtils.add((Object[])natures, (Object)"org.eclipse.jdt.core.javanature");
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
                TemporaryProject.this.javaProject = JavaCore.create((IProject)project);
            }

            private void addSourcePackageFragmentRoot(IProject project) throws CoreException {
                IFolder sourceFolder = project.getFolder(TemporaryProject.SRC_FOLDER_NAME);
                sourceFolder.create(false, true, null);
                IPackageFragmentRoot src = TemporaryProject.this.javaProject.getPackageFragmentRoot((IResource)sourceFolder);
                IClasspathEntry[] entries = TemporaryProject.this.javaProject.getRawClasspath();
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getPath().toString().equals(String.valueOf(File.separator) + TemporaryProject.this.name)) {
                        entries[i] = JavaCore.newSourceEntry((IPath)src.getPath());
                        break;
                    }
                    ++i;
                }
                TemporaryProject.this.javaProject.setRawClasspath(entries, null);
            }
        };
        try {
            this.workspace.run(populate, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Throws.throwUnhandledException((Exception)e);
        }
        this.javaProject = JavaCore.create((IProject)this.project);
    }

    public TemporaryProject withDependencyOn(TemporaryProject dependency) throws JavaModelException {
        this.addToClasspath(JavaCore.newProjectEntry((IPath)dependency.getProject().getFullPath()));
        return this;
    }

    public TemporaryProject withDependencyOnClassesOf(TemporaryProject dependency) throws JavaModelException {
        IFolder classFileFolder = dependency.getProjectClassFileDirectory();
        this.addToClasspath(JavaCore.newLibraryEntry((IPath)classFileFolder.getFullPath(), null, null));
        return this;
    }

    public TemporaryProject withDependencyOnJarOf(TemporaryProject dependency) throws IOException, JavaModelException {
        this.addToClasspath(JavaCore.newLibraryEntry((IPath)dependency.createJar(), null, null));
        return this;
    }

    public TemporaryFile createFile(CharSequence code) throws CoreException {
        TemporaryFile tempFile = new TemporaryFile(this, code);
        this.temporaryFiles.add(tempFile);
        return tempFile;
    }

    private void addToClasspath(IClasspathEntry classpathEntry) throws JavaModelException {
        HashSet entries = Sets.newHashSet();
        entries.addAll(Arrays.asList(this.javaProject.getRawClasspath()));
        entries.add(classpathEntry);
        IClasspathEntry[] classpaths = entries.toArray(new IClasspathEntry[entries.size()]);
        this.javaProject.setRawClasspath(classpaths, null);
    }

    private IFolder getProjectClassFileDirectory() {
        return this.project.getFolder(BIN_FOLDER_NAME);
    }

    private Path createJar() throws IOException {
        String jarPath = this.getJarPath();
        String pathToClassDirectory = String.valueOf(this.getAbsolutePathString()) + File.separator + BIN_FOLDER_NAME;
        File classFileDirectory = new File(pathToClassDirectory);
        Zips.zip((File)classFileDirectory, (File)new File(jarPath));
        return new Path(jarPath);
    }

    public String getJarPath() {
        return String.valueOf(this.getAbsolutePathString()) + File.separator + this.getName() + ".jar";
    }

    String getName() {
        return this.name;
    }

    IProject getProject() {
        return this.project;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    String getAbsolutePathString() {
        return this.project.getLocation().toString();
    }

    String getWorkspaceRelativePathString() {
        return this.project.getFullPath().toString();
    }

    void refreshAndBuildProject() throws CoreException {
        this.project.refreshLocal(2, null);
        this.project.build(6, null);
    }
}

