/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;

public class SimpleProposalProcessor
extends ProposalProcessor {
    private final int increment;
    private final String addon;

    public SimpleProposalProcessor(int increment, String addon) {
        this.increment = increment;
        this.addon = addon;
    }

    public SimpleProposalProcessor(int increment) {
        this(increment, null);
    }

    @Override
    public int modifyRelevance() {
        return this.increment;
    }

    @Override
    public void modifyDisplayString(StyledString displayString) {
        if (!StringUtils.isEmpty((CharSequence)this.addon)) {
            displayString.append(" - " + this.addon, StyledString.COUNTER_STYLER);
        }
    }

    @VisibleForTesting
    public int getIncrement() {
        return this.increment;
    }

    @VisibleForTesting
    public String getAddon() {
        return this.addon;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        SimpleProposalProcessor that = (SimpleProposalProcessor)other;
        if (this.addon == null ? that.addon != null : !this.addon.equals(that.addon)) {
            return false;
        }
        return this.increment == that.increment;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.addon == null ? 0 : this.addon.hashCode());
        result = 31 * result + this.increment;
        return result;
    }
}

