/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp.completion;

import com.google.common.base.Optional;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.recommenders.injection.InjectionService;
import org.eclipse.recommenders.internal.snipmatch.rcp.completion.JavaContentAssistProcessor;
import org.eclipse.recommenders.internal.snipmatch.rcp.completion.SnipmatchCompletionEngine;
import org.eclipse.recommenders.internal.snipmatch.rcp.completion.TextContentAssistInvocationContext;
import org.eclipse.recommenders.internal.snipmatch.rcp.completion.TextContentAssistProcessor;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.Messages;
import org.eclipse.recommenders.utils.Reflections;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class CompletionHandler
extends AbstractHandler {
    private <T> T request(Class<T> clazz) {
        return (T)InjectionService.getInstance().requestInstance(clazz);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPathEditorInput editorInput;
        ISourceViewer viewer;
        IEditorPart editor = (IEditorPart)this.getActiveEditor(event).orNull();
        if (editor == null) {
            return null;
        }
        if (!(editor instanceof ITextEditor)) {
            return null;
        }
        ITextEditor textEditor = (ITextEditor)editor;
        if (!textEditor.isEditable()) {
            return null;
        }
        IPersistableElement persistable = textEditor.getEditorInput().getPersistable();
        if (persistable == null) {
            return null;
        }
        Method getSourceViewerMethod = (Method)Reflections.getDeclaredMethod(AbstractTextEditor.class, (String)"getSourceViewer", (Class[])new Class[0]).orNull();
        if (getSourceViewerMethod == null) {
            throw new ExecutionException(Messages.ERROR_UNABLE_TO_DETERMINE_SOURCE_VIEWER);
        }
        try {
            viewer = (ISourceViewer)getSourceViewerMethod.invoke((Object)textEditor, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new ExecutionException(Messages.ERROR_UNABLE_TO_DETERMINE_SOURCE_VIEWER, (Throwable)e);
        }
        int offset = viewer.getSelectedRange().x;
        String filename = null;
        if (persistable instanceof IPathEditorInput) {
            editorInput = (IPathEditorInput)persistable;
            filename = editorInput.getPath().toFile().getName();
        } else if (persistable instanceof FileStoreEditorInput) {
            editorInput = (FileStoreEditorInput)persistable;
            try {
                filename = new File(editorInput.getURI()).getName();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        SnipmatchCompletionEngine<? extends ContentAssistInvocationContext> engine = textEditor instanceof JavaEditor ? this.createCompletionEngineForJava((IEditorPart)textEditor, viewer, offset, filename) : this.createCompletionEngineForText(textEditor.getEditorInput(), viewer, offset, filename);
        engine.show();
        return null;
    }

    private Optional<IEditorPart> getActiveEditor(ExecutionEvent event) {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor instanceof FormEditor) {
            FormEditor formEditor = (FormEditor)editor;
            return Optional.fromNullable((Object)formEditor.getActiveEditor());
        }
        if (editor instanceof MultiPageEditorPart) {
            MultiPageEditorPart multiPageEditorPart = (MultiPageEditorPart)editor;
            Object selectedPage = multiPageEditorPart.getSelectedPage();
            if (selectedPage instanceof IEditorPart) {
                return Optional.fromNullable((Object)((IEditorPart)selectedPage));
            }
            return Optional.absent();
        }
        return Optional.fromNullable((Object)editor);
    }

    private SnipmatchCompletionEngine<? extends ContentAssistInvocationContext> createCompletionEngineForJava(IEditorPart editor, ISourceViewer viewer, int offset, String filename) {
        JavaContentAssistInvocationContext context = new JavaContentAssistInvocationContext((ITextViewer)viewer, offset, editor);
        JavaContentAssistProcessor processor = this.request(JavaContentAssistProcessor.class);
        return new SnipmatchCompletionEngine<JavaContentAssistInvocationContext>(context, processor, filename, this.request(EventBus.class), this.request(ColorRegistry.class), this.request(FontRegistry.class));
    }

    private SnipmatchCompletionEngine<? extends ContentAssistInvocationContext> createCompletionEngineForText(IEditorInput input, ISourceViewer viewer, int offset, String filename) {
        IJavaProject javaProject = EditorUtility.getJavaProject((IEditorInput)input);
        TextContentAssistInvocationContext context = new TextContentAssistInvocationContext((ITextViewer)viewer, offset, javaProject);
        TextContentAssistProcessor processor = this.request(TextContentAssistProcessor.class);
        return new SnipmatchCompletionEngine<TextContentAssistInvocationContext>(context, processor, filename, this.request(EventBus.class), this.request(ColorRegistry.class), this.request(FontRegistry.class));
    }
}

