/**
 * Copyright (c) 2010, 2011 Darmstadt University of Technology.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Marcel Bruch - initial API and implementation.
 */
package org.eclipse.recommenders.testing;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class CodeBuilder {
  private static AtomicInteger classCounter = new AtomicInteger();
  
  public static String classname() {
    int _addAndGet = CodeBuilder.classCounter.addAndGet(1);
    return ("TestClass" + Integer.valueOf(_addAndGet));
  }
  
  public static CharSequence classbody(final CharSequence classbody) {
    String _classname = CodeBuilder.classname();
    return CodeBuilder.classbody(_classname, classbody);
  }
  
  public static CharSequence classbody(final CharSequence classname, final CharSequence classbody) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public class ");
    _builder.append(classname, "");
    _builder.append(" ");
    return CodeBuilder.classDeclaration(_builder, classbody);
  }
  
  public static CharSequence classDeclaration(final CharSequence declaration, final CharSequence body) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("import java.lang.reflect.*;");
    _builder.newLine();
    _builder.append("import java.lang.annotation.*;");
    _builder.newLine();
    _builder.append("import java.math.*;");
    _builder.newLine();
    _builder.append("import java.io.*;");
    _builder.newLine();
    _builder.append("import java.text.*;");
    _builder.newLine();
    _builder.append("import java.util.*;");
    _builder.newLine();
    _builder.append("import java.util.concurrent.*;");
    _builder.newLine();
    _builder.append("import java.util.concurrent.atomic.*;");
    _builder.newLine();
    _builder.append("import javax.annotation.*;");
    _builder.newLine();
    _builder.append("import javax.xml.ws.Action;");
    _builder.newLine();
    _builder.append(declaration, "");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(body, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public static CharSequence method(final CharSequence methodbody) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public void __test() throws Exception {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(methodbody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    return CodeBuilder.classbody(_builder);
  }
  
  public static CharSequence method(final CharSequence classname, final CharSequence methodbody) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("public void __test() throws Exception {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(methodbody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    return CodeBuilder.classbody(classname, _builder);
  }
  
  public static CharSequence classWithFieldsAndTestMethod(final CharSequence fieldDeclarations, final CharSequence methodbody) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append(fieldDeclarations, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public void __test() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(methodbody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    return CodeBuilder.classbody(_builder);
  }
}
