/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.transformation;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.factor.AbstractFactor;
import org.eclipse.recommenders.jayes.factor.DenseFactor;
import org.eclipse.recommenders.jayes.factor.arraywrapper.DoubleArrayWrapper;
import org.eclipse.recommenders.jayes.factor.arraywrapper.IArrayWrapper;
import org.eclipse.recommenders.jayes.transformation.IDecompositionStrategy;
import org.eclipse.recommenders.jayes.transformation.util.ArrayFlatten;
import org.eclipse.recommenders.jayes.transformation.util.CanonicalDoubleArrayManager;
import org.eclipse.recommenders.jayes.transformation.util.DecompositionFailedException;
import org.eclipse.recommenders.jayes.util.MathUtils;

public abstract class AbstractDecomposition
implements IDecompositionStrategy {
    @Override
    public final void decompose(BayesNet net, BayesNode node) throws DecompositionFailedException {
        if (!net.getNodes().contains(node)) {
            throw new IllegalArgumentException("Node " + node + " is not part of the bayesnet " + net.getName());
        }
        AbstractFactor f = node.getFactor();
        if (f.getDimensions().length == 1) {
            throw new DecompositionFailedException("Node " + node + " has no parents, impossible to decompose");
        }
        f = this.reorderFactor(f);
        int[] dimensions = f.getDimensions();
        List<double[]> vectors = ArrayFlatten.unflatten(f.getValues().toDoubleArray(), dimensions[dimensions.length - 1]);
        List<double[]> basis = this.getBasis(f, vectors);
        double[] latentProb = this.getLatentProbabilities(vectors, basis);
        if (f == node.getFactor()) {
            this.createLatentNodeInOriginalOrder(net, node, basis, latentProb);
        } else {
            this.createLatentNodeReordered(net, node, f, basis, latentProb);
        }
    }

    private AbstractFactor reorderFactor(AbstractFactor f) {
        int min;
        int[] dimensions = f.getDimensions();
        int minIndex = Ints.lastIndexOf((int[])dimensions, (int)(min = Ints.min((int[])dimensions)));
        if (minIndex == dimensions.length - 1) {
            return f;
        }
        int[] nDim = this.rotateRight(dimensions, dimensions.length - 1 - minIndex);
        int[] nIDs = this.rotateRight(f.getDimensionIDs(), dimensions.length - 1 - minIndex);
        DenseFactor f2 = new DenseFactor();
        f2.setDimensionIDs(nIDs);
        f2.setDimensions(nDim);
        f2.fill(1.0);
        f2.multiplyCompatible(f);
        return f2;
    }

    protected abstract List<double[]> getBasis(AbstractFactor var1, List<double[]> var2) throws DecompositionFailedException;

    private double[] getLatentProbabilities(List<double[]> vectors, List<double[]> best) throws DecompositionFailedException {
        CanonicalDoubleArrayManager canon = new CanonicalDoubleArrayManager();
        best = Lists.transform(best, (Function)canon);
        vectors = Lists.transform(vectors, (Function)canon);
        List<double[]> newVectors = this.toLatentSpace(vectors, (List<double[]>)best);
        return ArrayFlatten.flatten((double[][])newVectors.toArray((T[])new double[0][]));
    }

    private List<double[]> toLatentSpace(List<double[]> vectors, List<double[]> best) throws DecompositionFailedException {
        ArrayList<double[]> latent = new ArrayList<double[]>();
        for (double[] v : vectors) {
            latent.add(this.toLatentSpace(v, best));
        }
        return latent;
    }

    protected abstract double[] toLatentSpace(double[] var1, List<double[]> var2) throws DecompositionFailedException;

    private void createLatentNodeInOriginalOrder(BayesNet net, BayesNode node, List<double[]> basis, double[] latentProb) {
        BayesNode newNode = net.createNode("latent-" + node.getName());
        this.addOutcomes(newNode, basis.size());
        newNode.setParents(node.getParents());
        newNode.setProbabilities(latentProb);
        node.setParents(Arrays.asList(newNode));
        node.setProbabilities(ArrayFlatten.flatten((double[][])basis.toArray((T[])new double[0][])));
    }

    private void createLatentNodeReordered(BayesNet net, BayesNode node, AbstractFactor f, List<double[]> basis, double[] latentProb) {
        BayesNode newNode = net.createNode("latent-" + node.getName());
        this.addOutcomes(newNode, basis.size());
        int[] dimensions = f.getDimensions();
        BayesNode parentNode = net.getNode(f.getDimensionIDs()[dimensions.length - 1]);
        newNode.setParents(Arrays.asList(parentNode));
        newNode.setProbabilities(ArrayFlatten.flatten((double[][])this.transpose(basis).toArray((T[])new double[0][])));
        ArrayList<BayesNode> parents = new ArrayList<BayesNode>(node.getParents());
        int index = parents.indexOf(parentNode);
        parents.remove(parentNode);
        parents.add(index, newNode);
        node.setParents(parents);
        double[] nodeProbs = this.undoReordering(latentProb, node.getFactor(), f, newNode.getId());
        node.setProbabilities(nodeProbs);
    }

    private void addOutcomes(BayesNode newNode, int d) {
        int i = 0;
        while (i < d) {
            newNode.addOutcome("outcome" + i);
            ++i;
        }
    }

    private double[] undoReordering(double[] latentProb, AbstractFactor originalFactor, AbstractFactor newFactor, int originalId) {
        AbstractFactor o2 = originalFactor.clone();
        AbstractFactor n2 = newFactor.clone();
        n2.getDimensionIDs()[n2.getDimensionIDs().length - 1] = originalId;
        int oInd = Ints.indexOf((int[])o2.getDimensionIDs(), (int)originalId);
        n2.getDimensions()[n2.getDimensions().length - 1] = o2.getDimensions()[oInd];
        n2.setValues((IArrayWrapper)new DoubleArrayWrapper(latentProb));
        o2.setValues((IArrayWrapper)new DoubleArrayWrapper(new double[MathUtils.product((int[])o2.getDimensions())]));
        o2.fill(1.0);
        o2.multiplyCompatible(n2);
        return o2.getValues().toDoubleArray();
    }

    protected final List<double[]> transpose(List<double[]> best) {
        ArrayList<double[]> result = new ArrayList<double[]>();
        int i = 0;
        while (i < best.get(0).length) {
            result.add(new double[best.size()]);
            ++i;
        }
        i = 0;
        while (i < best.size()) {
            double[] arr = best.get(i);
            int j = 0;
            while (j < arr.length) {
                ((double[])result.get((int)j))[i] = arr[j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    private int[] rotateRight(int[] array, int amount) {
        int[] result = new int[array.length];
        System.arraycopy(array, 0, result, amount, array.length - amount);
        System.arraycopy(array, array.length - amount, result, 0, amount);
        return result;
    }
}

