/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.advisors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import org.eclipse.recommenders.coordinates.AbstractProjectCoordinateAdvisor;
import org.eclipse.recommenders.coordinates.Coordinates;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.DependencyType;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.coordinates.osgi.OsgiManifestAdvisor;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.utils.Versions;

public class ModelIndexBundleSymbolicNameAdvisor
extends AbstractProjectCoordinateAdvisor {
    private final OsgiManifestAdvisor osgi;
    private final IModelIndex indexer;

    public ModelIndexBundleSymbolicNameAdvisor(IModelIndex indexer) {
        this(indexer, new OsgiManifestAdvisor());
    }

    @VisibleForTesting
    ModelIndexBundleSymbolicNameAdvisor(IModelIndex indexer, OsgiManifestAdvisor osgi) {
        this.indexer = indexer;
        this.osgi = osgi;
    }

    protected Optional<ProjectCoordinate> doSuggest(DependencyInfo dependencyInfo) {
        ProjectCoordinate osgiPc = (ProjectCoordinate)this.osgi.suggest(dependencyInfo).orNull();
        if (osgiPc == null) {
            return Optional.absent();
        }
        String symbolicName = osgiPc.getArtifactId();
        ProjectCoordinate indexPc = (ProjectCoordinate)this.indexer.suggestProjectCoordinateByArtifactId(symbolicName).orNull();
        if (indexPc == null) {
            return Optional.absent();
        }
        return Coordinates.tryNewProjectCoordinate((String)indexPc.getGroupId(), (String)indexPc.getArtifactId(), (String)Versions.canonicalizeVersion((String)indexPc.getVersion()));
    }

    protected boolean isApplicable(DependencyType dependencyType) {
        return this.osgi.isApplicable(dependencyType);
    }
}

