/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.coordinates.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.DependencyType;
import org.eclipse.recommenders.rcp.utils.JdtUtils;

public final class DependencyInfos {
    private DependencyInfos() {
    }

    public static Optional<DependencyInfo> createJreDependencyInfo(IJavaProject javaProject) {
        Optional<String> executionEnvironmentId = DependencyInfos.getExecutionEnvironmentId(javaProject);
        try {
            IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
            if (vmInstall == null) {
                return Optional.absent();
            }
            File javaHome = vmInstall.getInstallLocation();
            HashMap<String, String> hints = new HashMap<String, String>();
            if (executionEnvironmentId.isPresent()) {
                hints.put("EXECUTION_ENVIRONMENT", (String)executionEnvironmentId.get());
            }
            return Optional.of((Object)new DependencyInfo(javaHome, DependencyType.JRE, hints));
        }
        catch (CoreException coreException) {
            return Optional.absent();
        }
    }

    private static Optional<String> getExecutionEnvironmentId(IJavaProject javaProject) {
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5) {
                    return Optional.fromNullable((Object)JavaRuntime.getExecutionEnvironmentId((IPath)entry.getPath()));
                }
                ++n2;
            }
            return Optional.absent();
        }
        catch (JavaModelException javaModelException) {
            return Optional.absent();
        }
    }

    public static Optional<DependencyInfo> createJarDependencyInfo(IPackageFragmentRoot pfr) {
        File file = (File)JdtUtils.getLocation((IPackageFragmentRoot)pfr).orNull();
        if (file == null) {
            return Optional.absent();
        }
        return Optional.of((Object)new DependencyInfo(file, DependencyType.JAR));
    }

    public static Optional<DependencyInfo> createProjectDependencyInfo(IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        if (project == null) {
            return Optional.absent();
        }
        IPath path = project.getLocation();
        if (path == null) {
            return Optional.absent();
        }
        File file = path.toFile();
        return Optional.of((Object)new DependencyInfo(file, DependencyType.PROJECT, (Map)ImmutableMap.of((Object)"PROJECT_NAME", (Object)javaProject.getElementName())));
    }
}

