/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp;

import com.google.common.base.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.recommenders.utils.Checks;

public class JavaElementSelectionEvent {
    private final IJavaElement element;
    private final JavaElementSelectionLocation location;
    private final Optional<ASTNode> selection;

    public JavaElementSelectionEvent(IJavaElement element, JavaElementSelectionLocation location) {
        this(element, location, null);
    }

    public JavaElementSelectionEvent(IJavaElement element, JavaElementSelectionLocation location, ASTNode selection) {
        this.element = element;
        this.location = location;
        this.selection = Optional.fromNullable((Object)selection);
    }

    public IJavaElement getElement() {
        return this.element;
    }

    public JavaElementSelectionLocation getLocation() {
        return this.location;
    }

    public Optional<ASTNode> getSelectedNode() {
        return this.selection;
    }

    public boolean equals(Object obj) {
        boolean sameElementAndSameLocation = EqualsBuilder.reflectionEquals((Object)obj, (Object)this, (String[])new String[]{"selection"});
        if (!sameElementAndSameLocation) {
            return false;
        }
        JavaElementSelectionEvent other = (JavaElementSelectionEvent)Checks.cast((Object)obj);
        if (sameElementAndSameLocation && this.sameLocation(other)) {
            return true;
        }
        if (!this.selection.isPresent()) {
            return true;
        }
        return this.bothSelectionsInsideJavadoc(other);
    }

    private boolean bothSelectionsInsideJavadoc(JavaElementSelectionEvent other) {
        boolean newSelectionInJavadoc;
        ASTNode currentNode = (ASTNode)this.selection.get();
        ASTNode newNode = (ASTNode)other.getSelectedNode().get();
        boolean currentSelectionInJavadoc = currentNode instanceof Javadoc || currentNode instanceof TagElement;
        boolean bl = newSelectionInJavadoc = newNode instanceof Javadoc || newNode instanceof TagElement;
        return currentSelectionInJavadoc && newSelectionInJavadoc;
    }

    private boolean sameLocation(JavaElementSelectionEvent other) {
        return this.location.equals((Object)other.location);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static enum JavaElementSelectionLocation {
        WORKSPACE,
        PROJECT,
        CLASSPATH_CONTAINER,
        PACKAGE_FRAGMENT_ROOT,
        PACKAGE_DECLARATION,
        IMPORT_DECLARATION,
        TYPE_DECLARATION,
        TYPE_DECLARATION_EXTENDS,
        TYPE_DECLARATION_IMPLEMENTS,
        FIELD_DECLARATION,
        FIELD_DECLARATION_INITIALIZER,
        METHOD_DECLARATION,
        METHOD_DECLARATION_RETURN,
        METHOD_DECLARATION_PARAMETER,
        METHOD_DECLARATION_THROWS,
        METHOD_BODY,
        UNKNOWN;

    }
}

