/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.eventbus.EventBus;
import com.google.common.io.Files;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Singleton;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.recommenders.internal.snipmatch.rcp.Repositories;
import org.eclipse.recommenders.internal.snipmatch.rcp.RepositoryConfigurations;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnipmatchRcpPreferences;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.LogMessages;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.model.SnippetRepositoryConfigurations;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public class SnipmatchRcpModule
extends AbstractModule {
    public static final String SNIPPET_REPOSITORY_BASEDIR = "SNIPPET_REPOSITORY_BASEDIR";
    public static final String SNIPPET_REPOSITORY_PROVIDERS = "SNIPPET_REPOSITORY_PROVIDERS";
    public static final String REPOSITORY_CONFIGURATION_FILE = "REPOSITORY_CONFIGURATION_FILE";
    private static final String SNIPMATCH_ROOT_FOLDER = "SNIPMATCH_ROOT_FOLDER";

    protected void configure() {
        this.bind(Repositories.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @Named(value="SNIPMATCH_ROOT_FOLDER")
    public File provideSnipmatchRoot(IWorkspaceRoot root) {
        File recommendersRoot = new File(root.getLocation().toFile(), ".recommenders");
        File snipmatchRoot = new File(recommendersRoot, "snipmatch");
        return snipmatchRoot;
    }

    @Provides
    @Singleton
    @Named(value="SNIPPET_REPOSITORY_BASEDIR")
    public File provideBasedir(IWorkspaceRoot root, @Named(value="SNIPMATCH_ROOT_FOLDER") File snipmatchRoot) {
        File snippetRepositoryBasedir = new File(snipmatchRoot, "repositories");
        try {
            Files.createParentDirs((File)snippetRepositoryBasedir);
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_BIND_FILE, (Throwable)e, (Object[])new Object[]{snippetRepositoryBasedir});
        }
        return snippetRepositoryBasedir;
    }

    @Provides
    @Singleton
    public SnipmatchRcpPreferences provide(IWorkbench wb, EventBus bus) {
        IEclipseContext context = (IEclipseContext)wb.getService(IEclipseContext.class);
        context.set(EventBus.class, (Object)bus);
        return (SnipmatchRcpPreferences)ContextInjectionFactory.make(SnipmatchRcpPreferences.class, (IEclipseContext)context);
    }

    @Provides
    @Singleton
    @Named(value="REPOSITORY_CONFIGURATION_FILE")
    public File provideConfigurationFile(IWorkspaceRoot root, @Named(value="SNIPMATCH_ROOT_FOLDER") File snipmatchRoot) {
        return new File(snipmatchRoot, "repositories.config");
    }

    @Provides
    @Singleton
    public SnippetRepositoryConfigurations provideRepositoryConfigurations(@Named(value="REPOSITORY_CONFIGURATION_FILE") File repositoryConfigurationFile) {
        SnippetRepositoryConfigurations configurations = RepositoryConfigurations.loadConfigurations(repositoryConfigurationFile);
        List<SnippetRepositoryConfiguration> defaultConfigurations = RepositoryConfigurations.fetchDefaultConfigurations();
        configurations = this.updateDefaultConfigurations(configurations, defaultConfigurations);
        RepositoryConfigurations.storeConfigurations(configurations, repositoryConfigurationFile);
        return configurations;
    }

    private SnippetRepositoryConfigurations updateDefaultConfigurations(SnippetRepositoryConfigurations configurations, List<SnippetRepositoryConfiguration> defaultConfigurations) {
        HashMap<String, SnippetRepositoryConfiguration> mapping = new HashMap<String, SnippetRepositoryConfiguration>();
        for (SnippetRepositoryConfiguration config : defaultConfigurations) {
            mapping.put(config.getId(), config);
        }
        ArrayList<SnippetRepositoryConfiguration> configs = new ArrayList<SnippetRepositoryConfiguration>();
        for (SnippetRepositoryConfiguration config : configurations.getRepos()) {
            if (mapping.containsKey(config.getId())) continue;
            configs.add(config);
        }
        configs.addAll(defaultConfigurations);
        configurations.getRepos().clear();
        configurations.getRepos().addAll(configs);
        return configurations;
    }

    @Provides
    public IThemeManager provideThemeManager(IWorkbench wb) throws PartInitException {
        return wb.getThemeManager();
    }

    @Provides
    public ITheme provideThemeManager(IThemeManager mgr) throws PartInitException {
        return mgr.getCurrentTheme();
    }

    @Provides
    public ColorRegistry provideColorRegistry(ITheme theme) throws PartInitException {
        return theme.getColorRegistry();
    }

    @Provides
    public FontRegistry provideFontRegistry(ITheme theme) throws PartInitException {
        return theme.getFontRegistry();
    }
}

