/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.codeassist.InternalExtendedCompletionContext;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnLocalName;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedAllocationExpression;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedNameReference;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.ICompletionContextFunction;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.ProposalCollectingCompletionRequestor;
import org.eclipse.recommenders.internal.completion.rcp.LogMessages;
import org.eclipse.recommenders.jdt.AstBindings;
import org.eclipse.recommenders.jdt.JavaElementsFinder;
import org.eclipse.recommenders.rcp.utils.ASTNodeUtils;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.rcp.utils.TimeDelimitedProgressMonitor;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Reflections;
import org.eclipse.recommenders.utils.names.IPackageName;
import org.eclipse.recommenders.utils.names.ITypeName;

public final class CompletionContextFunctions {
    private static final long COMPLETION_TIME_OUT = TimeUnit.SECONDS.toMillis(5L);

    private CompletionContextFunctions() {
        throw new IllegalStateException("Not meant to be instantiated");
    }

    public static Map<CompletionContextKey, ICompletionContextFunction> defaultFunctions() {
        HashMap<CompletionContextKey, ICompletionContextFunction> res = new HashMap<CompletionContextKey, ICompletionContextFunction>();
        res.put(CompletionContextKey.COMPLETION_PREFIX, new CompletionPrefixContextFunction());
        res.put(CompletionContextKey.IS_COMPLETION_ON_TYPE, new CompletionOnTypeContextFunction());
        res.put(CompletionContextKey.ENCLOSING_ELEMENT, new EnclosingElementContextFunction());
        res.put(CompletionContextKey.ENCLOSING_TYPE, new EnclosingTypeContextFunction());
        res.put(CompletionContextKey.ENCLOSING_METHOD, new EnclosingMethodContextFunction());
        res.put(CompletionContextKey.ENCLOSING_AST_METHOD, new EnclosingAstMethodContextFunction());
        res.put(CompletionContextKey.ENCLOSING_METHOD_FIRST_DECLARATION, new EnclosingMethodFirstDeclarationContextFunction());
        res.put(CompletionContextKey.EXPECTED_TYPE, new ExpectedTypeContextFunction());
        res.put(CompletionContextKey.EXPECTED_TYPENAMES, new ExpectedTypeNamesContextFunction());
        res.put(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, new InternalCompletionContextFunction());
        res.put(CompletionContextKey.JAVA_PROPOSALS, new InternalCompletionContextFunction());
        res.put(CompletionContextKey.LOOKUP_ENVIRONMENT, new LookupEnvironmentContextFunction());
        res.put(CompletionContextKey.RECEIVER_TYPEBINDING, new ReceiverTypeBindingContextFunction());
        res.put(CompletionContextKey.RECEIVER_NAME, new ReceiverNameContextFunction());
        res.put(CompletionContextKey.VISIBLE_METHODS, new VisibleMethodsContextFunction());
        res.put(CompletionContextKey.VISIBLE_FIELDS, new VisibleFieldsContextFunction());
        res.put(CompletionContextKey.VISIBLE_LOCALS, new VisibleLocalsContextFunction());
        res.put(CompletionContextKey.SESSION_ID, new SessionIdFunction());
        res.put(CompletionContextKey.IMPORTED_PACKAGES, new ImportedPackagesFunction());
        return res;
    }

    public static class CompletionOnTypeContextFunction
    implements ICompletionContextFunction<Boolean> {
        @Override
        public Boolean compute(IRecommendersCompletionContext context, CompletionContextKey<Boolean> key) {
            ASTNode node = (ASTNode)context.getCompletionNode().orNull();
            boolean res = false;
            if (node instanceof CompletionOnQualifiedNameReference) {
                Binding binding = ((CompletionOnQualifiedNameReference)node).binding;
                res = binding != null && 4 == binding.kind();
            }
            context.set(key, res);
            return res;
        }
    }

    public static class CompletionPrefixContextFunction
    implements ICompletionContextFunction<String> {
        @Override
        public String compute(IRecommendersCompletionContext context, CompletionContextKey<String> key) {
            InternalCompletionContext ctx = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
            char[] prefix = CharOperation.NO_CHAR;
            if (ctx != null) {
                prefix = (char[])Objects.firstNonNull((Object)ctx.getToken(), (Object)CharOperation.NO_CHAR);
            }
            String res = new String(prefix);
            context.set(key, res);
            return res;
        }
    }

    public static class EnclosingAstMethodContextFunction
    implements ICompletionContextFunction<MethodDeclaration> {
        @Override
        public MethodDeclaration compute(IRecommendersCompletionContext context, CompletionContextKey<MethodDeclaration> key) {
            MethodDeclaration astMethod = null;
            IMethod jdtMethod = (IMethod)context.getEnclosingMethod().orNull();
            if (jdtMethod != null) {
                Optional<CompilationUnit> ast = context.getAST();
                if (ast.isPresent()) {
                    astMethod = (MethodDeclaration)ASTNodeUtils.find((CompilationUnit)((CompilationUnit)ast.get()), (IMethod)jdtMethod).orNull();
                } else {
                    return null;
                }
            }
            context.set(key, astMethod);
            return astMethod;
        }
    }

    public static class EnclosingElementContextFunction
    implements ICompletionContextFunction<IJavaElement> {
        @Override
        public IJavaElement compute(IRecommendersCompletionContext context, CompletionContextKey<IJavaElement> key) {
            IJavaElement res = null;
            try {
                InternalCompletionContext core = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
                if (core != null && core.isExtended()) {
                    res = core.getEnclosingElement();
                }
            }
            catch (Exception exception) {}
            context.set(key, res);
            return res;
        }
    }

    public static class EnclosingMethodContextFunction
    implements ICompletionContextFunction<IMethod> {
        @Override
        public IMethod compute(IRecommendersCompletionContext context, CompletionContextKey<IMethod> key) {
            IJavaElement enclosing = context.get(CompletionContextKey.ENCLOSING_ELEMENT, null);
            IMethod res = (IMethod)(enclosing instanceof IMethod ? enclosing : null);
            context.set(key, res);
            return res;
        }
    }

    public static class EnclosingMethodFirstDeclarationContextFunction
    implements ICompletionContextFunction<IMethod> {
        @Override
        public IMethod compute(IRecommendersCompletionContext context, CompletionContextKey<IMethod> key) {
            IMethod root = null;
            IMethod enclosing = context.get(CompletionContextKey.ENCLOSING_METHOD, null);
            if (enclosing != null) {
                root = JdtUtils.findFirstDeclaration((IMethod)enclosing);
            }
            context.set(key, root);
            return root;
        }
    }

    public static class EnclosingTypeContextFunction
    implements ICompletionContextFunction<IType> {
        @Override
        public IType compute(IRecommendersCompletionContext context, CompletionContextKey<IType> key) {
            IJavaElement enclosing = context.get(CompletionContextKey.ENCLOSING_ELEMENT, null);
            IType res = null;
            if (enclosing instanceof IType) {
                res = (IType)enclosing;
            } else if (enclosing instanceof IField) {
                res = ((IField)enclosing).getDeclaringType();
            }
            context.set(key, res);
            return res;
        }
    }

    public static class ExpectedTypeContextFunction
    implements ICompletionContextFunction<IType> {
        @Override
        public IType compute(IRecommendersCompletionContext context, CompletionContextKey<IType> key) {
            JavaContentAssistInvocationContext ctx = context.get(CompletionContextKey.JAVA_CONTENTASSIST_CONTEXT, null);
            IType res = ctx == null ? null : ctx.getExpectedType();
            context.set(key, res);
            return res;
        }
    }

    public static class ExpectedTypeNamesContextFunction
    implements ICompletionContextFunction<Set<ITypeName>> {
        @Override
        public Set<ITypeName> compute(IRecommendersCompletionContext context, CompletionContextKey<Set<ITypeName>> key) {
            char[][] signatures;
            ASTNode completion = (ASTNode)context.getCompletionNode().orNull();
            InternalCompletionContext core = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
            if (this.isArgumentCompletion(completion) && context.getPrefix().isEmpty()) {
                ICompilationUnit cu = context.getCompilationUnit();
                int offset = context.getInvocationOffset();
                signatures = this.simulateCompletionWithFakePrefix(cu, offset);
            } else {
                signatures = core.getExpectedTypesSignatures();
            }
            HashSet res = Sets.newHashSet();
            char[][] cArray = (char[][])Objects.firstNonNull((Object)signatures, (Object)CharOperation.NO_CHAR_CHAR);
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char[] signature = cArray[n2];
                IJavaElement enclosing = (IJavaElement)context.getEnclosingElement().orNull();
                ITypeName resolved = (ITypeName)JavaElementsFinder.resolveType((char[])signature, (IJavaElement)enclosing).orNull();
                if (resolved != null) {
                    res.add(resolved);
                }
                ++n2;
            }
            context.set(key, res);
            return res;
        }

        private boolean isArgumentCompletion(ASTNode completion) {
            return completion instanceof MessageSend || completion instanceof CompletionOnQualifiedAllocationExpression;
        }

        private char[][] simulateCompletionWithFakePrefix(ICompilationUnit cu, int offset) {
            MutableObject res;
            block5: {
                res = new MutableObject(null);
                ICompilationUnit wc = null;
                String fakePrefix = "___x";
                try {
                    try {
                        wc = cu.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                        IBuffer buffer = wc.getBuffer();
                        String contents = buffer.getContents();
                        String newContents = String.valueOf(StringUtils.substring((String)contents, (int)0, (int)offset)) + fakePrefix + StringUtils.substring((String)contents, (int)offset, (int)contents.length());
                        buffer.setContents(newContents);
                        wc.codeComplete(offset + 1, new CompletionRequestor(true){

                            public boolean isExtendedContextRequired() {
                                return true;
                            }

                            public void acceptContext(CompletionContext context) {
                                res.setValue((Object)context.getExpectedTypesSignatures());
                                super.acceptContext(context);
                            }

                            public void accept(CompletionProposal proposal) {
                            }
                        });
                    }
                    catch (JavaModelException x) {
                        Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_EXCEPTION_DURING_CODE_COMPLETION, (Throwable)x);
                        this.discardWorkingCopy(wc);
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    this.discardWorkingCopy(wc);
                    throw throwable;
                }
                this.discardWorkingCopy(wc);
            }
            return (char[][])res.getValue();
        }

        private void discardWorkingCopy(ICompilationUnit wc) {
            try {
                if (wc != null) {
                    wc.discardWorkingCopy();
                }
            }
            catch (JavaModelException x) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_EXCEPTION_DURING_CODE_COMPLETION, (Throwable)x);
            }
        }
    }

    public static class ImportedPackagesFunction
    implements ICompletionContextFunction<Set<IPackageName>> {
        @Override
        public Set<IPackageName> compute(IRecommendersCompletionContext context, CompletionContextKey<Set<IPackageName>> key) {
            Optional<CompilationUnit> ast = context.getAST();
            HashSet res = Sets.newHashSet();
            List imports = null;
            if (!ast.isPresent()) {
                return res;
            }
            imports = ((CompilationUnit)ast.get()).imports();
            for (ImportDeclaration decl : imports) {
                IBinding b = decl.resolveBinding();
                if (b == null) continue;
                switch (b.getKind()) {
                    case 2: {
                        ITypeName type = (ITypeName)AstBindings.toTypeName((ITypeBinding)((ITypeBinding)b)).orNull();
                        if (type == null) break;
                        res.add(type.getPackage());
                        break;
                    }
                    case 1: {
                        IPackageName pkg = (IPackageName)AstBindings.toPackageName((IPackageBinding)((IPackageBinding)b)).orNull();
                        if (pkg == null) break;
                        res.add(pkg);
                        break;
                    }
                    case 4: {
                        ITypeName type = (ITypeName)AstBindings.toTypeName((ITypeBinding)((IMethodBinding)b).getDeclaringClass()).orNull();
                        if (type == null) break;
                        res.add(type.getPackage());
                        break;
                    }
                    case 3: {
                        ITypeName type = (ITypeName)AstBindings.toTypeName((ITypeBinding)((IVariableBinding)b).getDeclaringClass()).orNull();
                        if (type == null) break;
                        res.add(type.getPackage());
                    }
                }
            }
            context.set(key, res);
            return res;
        }
    }

    public static class InternalCompletionContextFunction
    implements ICompletionContextFunction<Object> {
        @Override
        public Object compute(IRecommendersCompletionContext context, CompletionContextKey<Object> key) {
            JavaContentAssistInvocationContext coreContext = context.getJavaContext();
            int offset = context.getInvocationOffset();
            if (offset == -1) {
                return null;
            }
            ICompilationUnit cu = context.getCompilationUnit();
            ProposalCollectingCompletionRequestor collector = new ProposalCollectingCompletionRequestor(coreContext);
            try {
                cu.codeComplete(offset, (CompletionRequestor)collector, (IProgressMonitor)new TimeDelimitedProgressMonitor(COMPLETION_TIME_OUT));
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_EXCEPTION_DURING_CODE_COMPLETION, (Throwable)e);
            }
            InternalCompletionContext internal = collector.getCoreContext();
            context.set(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, internal);
            Map<IJavaCompletionProposal, CompletionProposal> proposals = collector.getProposals();
            context.set(CompletionContextKey.JAVA_PROPOSALS, proposals);
            if (CompletionContextKey.INTERNAL_COMPLETIONCONTEXT.equals(key)) {
                return internal;
            }
            return proposals;
        }
    }

    public static class LookupEnvironmentContextFunction
    implements ICompletionContextFunction<LookupEnvironment> {
        private static Class<InternalCompletionContext> internalCompletionContextClass;
        private static Class<InternalExtendedCompletionContext> internalExtendedCompletionContextClass;
        private static final Field EXTENDED_CONTEXT;
        private static final Field LOOKUP_ENVIRONMENT;

        static {
            try {
                internalCompletionContextClass = InternalCompletionContext.class;
            }
            catch (LinkageError e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_LINKAGE_ERROR, (Throwable)e);
            }
            try {
                internalExtendedCompletionContextClass = InternalExtendedCompletionContext.class;
            }
            catch (LinkageError e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_LINKAGE_ERROR, (Throwable)e);
            }
            EXTENDED_CONTEXT = (Field)Reflections.getDeclaredField(internalCompletionContextClass, (String)"extendedContext").orNull();
            LOOKUP_ENVIRONMENT = (Field)Reflections.getDeclaredField(internalExtendedCompletionContextClass, (String)"lookupEnvironment").orNull();
        }

        @Override
        public LookupEnvironment compute(IRecommendersCompletionContext context, CompletionContextKey<LookupEnvironment> key) {
            InternalExtendedCompletionContext extCtx;
            block6: {
                InternalCompletionContext ctx;
                block5: {
                    if (EXTENDED_CONTEXT == null || LOOKUP_ENVIRONMENT == null) {
                        return null;
                    }
                    try {
                        ctx = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
                        if (ctx != null) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_EXCEPTION_WHILE_COMPUTING_LOOKUP_ENVIRONMENT, (Throwable)e);
                        return null;
                    }
                }
                extCtx = (InternalExtendedCompletionContext)Checks.cast((Object)EXTENDED_CONTEXT.get(ctx));
                if (extCtx != null) break block6;
                return null;
            }
            LookupEnvironment env = (LookupEnvironment)Checks.cast((Object)LOOKUP_ENVIRONMENT.get(extCtx));
            context.set(key, env);
            return env;
        }
    }

    public static class ReceiverNameContextFunction
    implements ICompletionContextFunction<String> {
        @Override
        public String compute(IRecommendersCompletionContext context, CompletionContextKey<String> key) {
            CompletionOnQualifiedNameReference c;
            ASTNode n = (ASTNode)context.getCompletionNode().orNull();
            if (n == null) {
                return "";
            }
            char[] name = null;
            if (n instanceof CompletionOnQualifiedNameReference) {
                c = (CompletionOnQualifiedNameReference)Checks.cast((Object)n);
                switch (c.binding.kind()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        VariableBinding b = (VariableBinding)c.binding;
                        name = b.name;
                    }
                }
            } else if (n instanceof CompletionOnLocalName) {
                c = (CompletionOnLocalName)Checks.cast((Object)n);
                name = c.realName;
            } else if (n instanceof CompletionOnSingleNameReference) {
                name = CharOperation.NO_CHAR;
            } else if (n instanceof CompletionOnMemberAccess) {
                c = (CompletionOnMemberAccess)Checks.cast((Object)n);
                if (c.receiver instanceof ThisReference) {
                    name = "this".toCharArray();
                } else if (c.receiver instanceof MessageSend) {
                    name = null;
                } else if (c.fieldBinding() != null) {
                    name = c.fieldBinding().name;
                } else if (c.localVariableBinding() != null) {
                    name = c.localVariableBinding().name;
                }
            }
            String res = new String((char[])Objects.firstNonNull((Object)name, (Object)CharOperation.NO_CHAR));
            res = res.replace(" ", "");
            context.set(key, res);
            return res;
        }
    }

    public static class ReceiverTypeBindingContextFunction
    implements ICompletionContextFunction<TypeBinding> {
        @Override
        public TypeBinding compute(IRecommendersCompletionContext context, CompletionContextKey<TypeBinding> key) {
            ASTNode n = (ASTNode)context.getCompletionNode().orNull();
            if (n == null) {
                return null;
            }
            TypeBinding receiver = null;
            if (!(n instanceof CompletionOnLocalName)) {
                if (n instanceof CompletionOnSingleNameReference) {
                    CompletionOnSingleNameReference c = (CompletionOnSingleNameReference)Checks.cast((Object)n);
                    receiver = c.resolvedType;
                } else if (n instanceof CompletionOnQualifiedNameReference) {
                    CompletionOnQualifiedNameReference c = (CompletionOnQualifiedNameReference)Checks.cast((Object)n);
                    switch (c.binding.kind()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            VariableBinding varBinding = (VariableBinding)c.binding;
                            receiver = varBinding.type;
                            break;
                        }
                        case 4: 
                        case 2052: {
                            receiver = (TypeBinding)c.binding;
                        }
                    }
                } else if (n instanceof CompletionOnMemberAccess) {
                    CompletionOnMemberAccess c = (CompletionOnMemberAccess)Checks.cast((Object)n);
                    receiver = c.actualReceiverType;
                }
            }
            context.set(key, receiver);
            return receiver;
        }
    }

    public static class SessionIdFunction
    implements ICompletionContextFunction<UUID> {
        @Override
        public UUID compute(IRecommendersCompletionContext context, CompletionContextKey<UUID> key) {
            UUID res = UUID.randomUUID();
            context.set(key, res);
            return res;
        }
    }

    public static class VisibleFieldsContextFunction
    implements ICompletionContextFunction<List<IField>> {
        @Override
        public List<IField> compute(IRecommendersCompletionContext context, CompletionContextKey<List<IField>> key) {
            InternalCompletionContext ctx = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
            if (ctx == null || !ctx.isExtended()) {
                return Collections.emptyList();
            }
            ObjectVector v = ctx.getVisibleFields();
            ArrayList res = Lists.newArrayListWithCapacity((int)v.size);
            int i = v.size();
            while (i-- > 0) {
                FieldBinding b = (FieldBinding)Checks.cast((Object)v.elementAt(i));
                Optional f = JdtUtils.createUnresolvedField((FieldBinding)b);
                if (!f.isPresent()) continue;
                res.add((IField)f.get());
            }
            context.set(key, res);
            return res;
        }
    }

    public static class VisibleLocalsContextFunction
    implements ICompletionContextFunction<List<ILocalVariable>> {
        @Override
        public List<ILocalVariable> compute(IRecommendersCompletionContext context, CompletionContextKey<List<ILocalVariable>> key) {
            InternalCompletionContext ctx = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
            if (ctx == null || !ctx.isExtended()) {
                return Collections.emptyList();
            }
            ObjectVector v = ctx.getVisibleLocalVariables();
            ArrayList res = Lists.newArrayListWithCapacity((int)v.size);
            int i = v.size();
            while (i-- > 0) {
                LocalVariableBinding b = (LocalVariableBinding)Checks.cast((Object)v.elementAt(i));
                JavaElement parent = (JavaElement)context.getEnclosingElement().get();
                ILocalVariable f = JdtUtils.createUnresolvedLocaVariable((VariableBinding)b, (JavaElement)parent);
                res.add(f);
            }
            context.set(key, res);
            return res;
        }
    }

    public static class VisibleMethodsContextFunction
    implements ICompletionContextFunction<List<IMethod>> {
        @Override
        public List<IMethod> compute(IRecommendersCompletionContext context, CompletionContextKey<List<IMethod>> key) {
            InternalCompletionContext ctx = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
            if (ctx == null || !ctx.isExtended()) {
                return Collections.emptyList();
            }
            ObjectVector v = ctx.getVisibleMethods();
            ArrayList res = Lists.newArrayListWithCapacity((int)v.size);
            int i = v.size();
            while (i-- > 0) {
                MethodBinding b = (MethodBinding)Checks.cast((Object)v.elementAt(i));
                Optional f = JdtUtils.createUnresolvedMethod((MethodBinding)b);
                if (!f.isPresent()) continue;
                res.add((IMethod)f.get());
            }
            context.set(key, res);
            return res;
        }
    }
}

