/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public final class Proposals {
    private static Map<CacheKey, Image> cache = Maps.newHashMap();

    private Proposals() {
        throw new IllegalStateException("Not meant to be instantiated");
    }

    public static void overlay(IProcessableProposal proposal, ImageDescriptor icon) {
        Proposals.overlay(proposal, icon, 0);
    }

    public static void overlay(IProcessableProposal proposal, ImageDescriptor icon, int decorationCorner) {
        Image originalImage = proposal.getImage();
        CacheKey key = new CacheKey(originalImage, icon, decorationCorner);
        Image newImage = cache.get(key);
        if (newImage == null) {
            DecorationOverlayIcon decorator = new DecorationOverlayIcon(originalImage, icon, decorationCorner);
            newImage = decorator.createImage();
            cache.put(key, newImage);
        }
        proposal.setImage(newImage);
    }

    public static IRecommendersCompletionContext getContext(IProcessableProposal proposal) {
        return (IRecommendersCompletionContext)proposal.getTag(ProposalTag.CONTEXT).orNull();
    }

    public static String getPrefix(IProcessableProposal proposal) {
        String prefix = proposal.getPrefix();
        if (prefix == null) {
            prefix = Proposals.getContext(proposal).getPrefix();
        }
        return prefix;
    }

    public static Optional<CompletionProposal> getCoreProposal(ICompletionProposal proposal) {
        if (proposal instanceof IProcessableProposal) {
            IProcessableProposal pp = (IProcessableProposal)proposal;
            return pp.getCoreProposal();
        }
        return Optional.absent();
    }

    public static <T> Optional<T> getTag(ICompletionProposal proposal, String tag) {
        if (proposal instanceof IProcessableProposal) {
            IProcessableProposal pp = (IProcessableProposal)proposal;
            for (IProposalTag t : pp.tags()) {
                if (!t.name().equals(tag)) continue;
                return pp.getTag(t);
            }
        }
        return Optional.absent();
    }

    public static boolean isKindOneOf(ICompletionProposal proposal, int ... kinds) {
        CompletionProposal cp = (CompletionProposal)Proposals.getCoreProposal(proposal).orNull();
        if (cp != null) {
            int[] nArray = kinds;
            int n = kinds.length;
            int n2 = 0;
            while (n2 < n) {
                int kind = nArray[n2];
                if (cp.getKind() == kind) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static StyledString copyStyledString(StyledString displayString) {
        StyledString copy = new StyledString(displayString.getString());
        StyleRange[] styleRangeArray = displayString.getStyleRanges();
        int n = styleRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            final StyleRange range = styleRangeArray[n2];
            copy.setStyle(range.start, range.length, new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.background = range.background;
                    textStyle.borderColor = range.borderColor;
                    textStyle.borderStyle = range.borderStyle;
                    textStyle.font = range.font;
                    textStyle.foreground = range.foreground;
                }
            });
            ++n2;
        }
        return copy;
    }

    private static final class CacheKey {
        final Image image;
        final ImageDescriptor overlay;
        final int corner;

        public CacheKey(Image image, ImageDescriptor overlay, int corner) {
            this.image = image;
            this.overlay = overlay;
            this.corner = corner;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.corner;
            result = 31 * result + (this.image == null ? 0 : this.image.hashCode());
            result = 31 * result + (this.overlay == null ? 0 : this.overlay.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.corner != other.corner) {
                return false;
            }
            if (this.image == null ? other.image != null : !this.image.equals((Object)other.image)) {
                return false;
            }
            return !(this.overlay == null ? other.overlay != null : !this.overlay.equals(other.overlay));
        }
    }
}

