/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.recommenders.internal.snipmatch.rcp.AbstractSnippetRepositoryWizard;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.Repositories;
import org.eclipse.recommenders.internal.snipmatch.rcp.RepositoryConfigurations;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnipmatchRcpPreferences;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnippetProposal;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnippetRepositoryTypeSelectionWizard;
import org.eclipse.recommenders.internal.snipmatch.rcp.WizardDescriptor;
import org.eclipse.recommenders.internal.snipmatch.rcp.WizardDescriptors;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.rcp.utils.Jobs;
import org.eclipse.recommenders.snipmatch.ISearchContext;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.Location;
import org.eclipse.recommenders.snipmatch.SearchContext;
import org.eclipse.recommenders.snipmatch.Snippet;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.SnippetEditor;
import org.eclipse.recommenders.snipmatch.rcp.SnippetEditorInput;
import org.eclipse.recommenders.snipmatch.rcp.SnippetRepositoryClosedEvent;
import org.eclipse.recommenders.snipmatch.rcp.SnippetRepositoryContentChangedEvent;
import org.eclipse.recommenders.snipmatch.rcp.SnippetRepositoryOpenedEvent;
import org.eclipse.recommenders.snipmatch.rcp.model.SnippetRepositoryConfigurations;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnippetsView
extends ViewPart
implements IRcpService {
    public static final String SEARCH_FIELD = "org.eclipse.recommenders.snipmatch.rcp.snippetsview.searchfield";
    public static final String TREE = "org.eclipse.recommenders.snipmatch.rcp.snippetsview.tree";
    public static final String SWT_ID = "org.eclipse.swtbot.widget.key";
    private static Logger LOG = LoggerFactory.getLogger(SnippetsView.class);
    private Text txtSearch;
    private TreeViewer treeViewer;
    private Tree tree;
    private IViewerObservableList selection;
    private SharedImages images;
    private final Repositories repos;
    private final SnippetRepositoryConfigurations configs;
    private final File repositoryConfigurationFile;
    private final EventBus bus;
    private final SnipmatchRcpPreferences prefs;
    private Action addRepositoryAction;
    private Action removeRepositoryAction;
    private Action editRepositoryAction;
    private Action enableRepositoryAction;
    private Action disableRepositoryAction;
    private Action refreshAction;
    private Action addSnippetAction;
    private Action removeSnippetAction;
    private Action editSnippetAction;
    private Action shareSnippetAction;
    private volatile boolean initializeTableData = true;
    private volatile List<SnippetRepositoryConfiguration> availableRepositories = Lists.newArrayList();
    private volatile ListMultimap<SnippetRepositoryConfiguration, KnownSnippet> snippetsGroupedByRepoName = LinkedListMultimap.create();
    private volatile ListMultimap<SnippetRepositoryConfiguration, KnownSnippet> filteredSnippetsGroupedByRepoName = LinkedListMultimap.create();
    private final Function<KnownSnippet, String> toStringRepresentation = new Function<KnownSnippet, String>(){

        public String apply(KnownSnippet input) {
            return SnippetProposal.createDisplayString(input.snippet);
        }
    };

    @Inject
    public SnippetsView(Repositories repos, SharedImages images, SnippetRepositoryConfigurations configs, EventBus bus, @Named(value="REPOSITORY_CONFIGURATION_FILE") File repositoryConfigurationFile, SnipmatchRcpPreferences prefs) {
        this.repos = repos;
        this.configs = configs;
        this.images = images;
        this.bus = bus;
        this.repositoryConfigurationFile = repositoryConfigurationFile;
        this.prefs = prefs;
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(composite);
        this.txtSearch = new Text(composite, 2944);
        this.txtSearch.setMessage(Messages.SEARCH_PLACEHOLDER_SEARCH_TEXT);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)this.txtSearch);
        this.txtSearch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnippetsView.this.refreshUI();
            }
        });
        this.txtSearch.setData(SWT_ID, (Object)SEARCH_FIELD);
        this.txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && SnippetsView.this.tree.getItemCount() != 0) {
                    SnippetsView.this.tree.setFocus();
                    SnippetsView.this.tree.setSelection(SnippetsView.this.tree.getTopItem());
                }
            }
        });
        Composite treeComposite = new Composite(composite, 0);
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)treeLayout);
        treeComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer = new TreeViewer(treeComposite, 268503042);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.tree = this.treeViewer.getTree();
        this.tree.setData(SWT_ID, (Object)TREE);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        TreeViewerColumn snippetViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn snippetColumn = snippetViewerColumn.getColumn();
        treeLayout.setColumnData((Widget)snippetColumn, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        snippetColumn.setText(Messages.TABLE_COLUMN_TITLE_SNIPPETS);
        snippetViewerColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                StyledString text = new StyledString();
                if (element instanceof SnippetRepositoryConfiguration) {
                    SnippetRepositoryConfiguration config = (SnippetRepositoryConfiguration)element;
                    text.append(config.getName());
                    text.append(" ");
                    if (SnippetsView.this.prefs.isRepositoryEnabled(config)) {
                        text.append(MessageFormat.format(Messages.TABLE_CELL_SUFFIX_SNIPPETS, SnippetsView.this.fetchNumberOfSnippets(config)), StyledString.COUNTER_STYLER);
                    } else {
                        text.append(Messages.TABLE_REPOSITORY_DISABLED, StyledString.COUNTER_STYLER);
                    }
                    cell.setImage(SnippetsView.this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_REPOSITORY));
                } else if (element instanceof KnownSnippet) {
                    KnownSnippet knownSnippet = (KnownSnippet)element;
                    text.append((String)SnippetsView.this.toStringRepresentation.apply((Object)knownSnippet));
                }
                cell.setText(text.toString());
                cell.setStyleRanges(text.getStyleRanges());
                super.update(cell);
            }
        });
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (SnippetsView.this.selectionConsistsOnlyElementsOf(KnownSnippet.class)) {
                    SnippetsView.this.editSnippets();
                }
            }
        });
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider((IContentProvider)new ILazyTreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public void updateElement(Object parent, int index) {
                if (parent instanceof IViewSite) {
                    SnippetRepositoryConfiguration config = (SnippetRepositoryConfiguration)SnippetsView.this.availableRepositories.get(index);
                    SnippetsView.this.treeViewer.replace(parent, index, (Object)config);
                    SnippetsView.this.treeViewer.setChildCount((Object)config, this.getChildren(config).length);
                } else if (parent instanceof SnippetRepositoryConfiguration) {
                    SnippetsView.this.treeViewer.replace(parent, index, this.getChildren(parent)[index]);
                }
            }

            private Object[] getChildren(Object element) {
                if (element instanceof SnippetRepositoryConfiguration) {
                    return SnippetsView.this.filteredSnippetsGroupedByRepoName.get((Object)((SnippetRepositoryConfiguration)element)).toArray();
                }
                return new Object[0];
            }

            public void updateChildCount(Object element, int currentChildCount) {
                int count = 0;
                if (element instanceof IViewSite) {
                    count = SnippetsView.this.availableRepositories.size();
                }
                if (SnippetsView.this.availableRepositories.contains(element)) {
                    count = this.getChildren(element).length;
                }
                if (count != currentChildCount) {
                    SnippetsView.this.treeViewer.setChildCount(element, count);
                }
            }

            public Object getParent(Object element) {
                if (element instanceof KnownSnippet) {
                    KnownSnippet knownSnippet = (KnownSnippet)element;
                    return knownSnippet.config;
                }
                return null;
            }
        });
        this.selection = ViewersObservables.observeMultiSelection((Viewer)this.treeViewer);
        this.createActions(parent);
        this.addToolBar(parent);
        this.addContextMenu();
        this.refreshUI();
    }

    private int fetchNumberOfSnippets(SnippetRepositoryConfiguration config) {
        return this.snippetsGroupedByRepoName.get((Object)config).size();
    }

    private void createActions(Composite parent) {
        this.addRepositoryAction = new Action(){

            public void run() {
                SnippetsView.this.addRepo();
            }
        };
        this.removeRepositoryAction = new Action(){

            public void run() {
                SnippetsView.this.removeRepos();
            }
        };
        this.editRepositoryAction = new Action(){

            public void run() {
                SnippetsView.this.editRepos();
            }
        };
        this.enableRepositoryAction = new Action(){

            public void run() {
                SnippetsView.this.changeEnableStateRepos(true);
            }
        };
        this.disableRepositoryAction = new Action(){

            public void run() {
                SnippetsView.this.changeEnableStateRepos(false);
            }
        };
        this.refreshAction = new Action(){

            public void run() {
                SnippetsView.this.reload();
            }
        };
        this.addSnippetAction = new Action(){

            public void run() {
                SnippetsView.this.addSnippet();
            }
        };
        this.removeSnippetAction = new Action(){

            public void run() {
                SnippetsView.this.removeSnippets();
            }
        };
        this.editSnippetAction = new Action(){

            public void run() {
                SnippetsView.this.editSnippets();
            }
        };
        this.shareSnippetAction = new Action(){

            public void run() {
                SnippetsView.this.shareSnippets();
            }
        };
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SnippetsView.this.updateActionsStatus();
            }
        });
        this.updateActionsStatus();
    }

    private void updateActionsStatus() {
        boolean removeRepoEnabled = false;
        boolean editRepoEnabled = false;
        boolean enableRepoEnabled = false;
        boolean disableRepoEnabled = false;
        boolean removeSnippetEnabled = false;
        boolean editSnippetEnabled = false;
        boolean shareSnippetEnabled = false;
        if (this.selectionContainsOnlyOneElementOf(SnippetRepositoryConfiguration.class)) {
            SnippetRepositoryConfiguration selectedConfig = (SnippetRepositoryConfiguration)this.selection.get(0);
            boolean bl = editRepoEnabled = WizardDescriptors.isWizardAvailable(selectedConfig) && !this.selectionContainsDefaultConfigurations();
        }
        if (this.selectionConsistsOnlyElementsOf(SnippetRepositoryConfiguration.class) && !this.selectionContainsDefaultConfigurations()) {
            removeRepoEnabled = true;
        }
        if (this.selectionContainsOnlyOneElementOf(SnippetRepositoryConfiguration.class)) {
            SnippetRepositoryConfiguration config = (SnippetRepositoryConfiguration)this.selection.get(0);
            boolean repositoryEnabled = this.prefs.isRepositoryEnabled(config);
            enableRepoEnabled = !repositoryEnabled;
            disableRepoEnabled = repositoryEnabled;
        }
        if (this.selectionConsistsOnlyElementsOf(KnownSnippet.class)) {
            removeSnippetEnabled = true;
            editSnippetEnabled = true;
        }
        if (this.selectionIsShareable()) {
            shareSnippetEnabled = true;
        }
        this.removeRepositoryAction.setEnabled(removeRepoEnabled);
        this.editRepositoryAction.setEnabled(editRepoEnabled);
        this.enableRepositoryAction.setEnabled(enableRepoEnabled);
        this.disableRepositoryAction.setEnabled(disableRepoEnabled);
        this.removeSnippetAction.setEnabled(removeSnippetEnabled);
        this.editSnippetAction.setEnabled(editSnippetEnabled);
        this.shareSnippetAction.setEnabled(shareSnippetEnabled);
    }

    private boolean selectionContainsDefaultConfigurations() {
        List configs = this.castSelection();
        for (SnippetRepositoryConfiguration config : configs) {
            if (!config.isDefaultConfiguration()) continue;
            return true;
        }
        return false;
    }

    private void addRepo() {
        List<WizardDescriptor> availableWizards = WizardDescriptors.loadAvailableWizards();
        if (!availableWizards.isEmpty()) {
            SnippetRepositoryTypeSelectionWizard newWizard = new SnippetRepositoryTypeSelectionWizard();
            WizardDialog dialog = new WizardDialog(this.tree.getShell(), (IWizard)newWizard);
            if (dialog.open() == 0) {
                SnippetRepositoryConfiguration newConfiguration = newWizard.getConfiguration();
                newConfiguration.setId(UUID.randomUUID().toString());
                this.configs.getRepos().add((Object)newConfiguration);
                RepositoryConfigurations.storeConfigurations(this.configs, this.repositoryConfigurationFile);
                this.bus.post((Object)new Repositories.SnippetRepositoryConfigurationChangedEvent());
                this.refreshUI();
            }
        }
    }

    private void removeRepos() {
        Checks.ensureIsTrue((boolean)this.selectionConsistsOnlyElementsOf(SnippetRepositoryConfiguration.class));
        List configurations = this.castSelection();
        for (SnippetRepositoryConfiguration config : configurations) {
            ISnippetRepository repo;
            boolean confirmed;
            MessageDialogWithToggle confirmDialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.tree.getShell(), (String)Messages.CONFIRM_DIALOG_DELETE_REPOSITORY_TITLE, (String)MessageFormat.format(Messages.CONFIRM_DIALOG_DELETE_REPOSITORY_MESSAGE, config.getName()), (String)Messages.CONFIRM_DIALOG_DELETE_REPOSITORY_TOGGLE_MESSAGE, (boolean)true, null, null);
            boolean bl = confirmed = confirmDialog.getReturnCode() == 0;
            if (!confirmed) {
                return;
            }
            boolean delete = confirmDialog.getToggleState();
            if (delete && (repo = (ISnippetRepository)this.repos.getRepository(config.getId()).orNull()) != null) {
                repo.delete();
            }
            this.configs.getRepos().remove((Object)config);
        }
        RepositoryConfigurations.storeConfigurations(this.configs, this.repositoryConfigurationFile);
        this.bus.post((Object)new Repositories.SnippetRepositoryConfigurationChangedEvent());
        this.refreshUI();
    }

    private void editRepos() {
        Checks.ensureIsTrue((boolean)this.selectionContainsOnlyOneElementOf(SnippetRepositoryConfiguration.class));
        SnippetRepositoryConfiguration oldConfiguration = (SnippetRepositoryConfiguration)Checks.cast((Object)this.selection.get(0));
        List<WizardDescriptor> suitableWizardDescriptors = WizardDescriptors.filterApplicableWizardDescriptors(WizardDescriptors.loadAvailableWizards(), oldConfiguration);
        if (!suitableWizardDescriptors.isEmpty()) {
            AbstractSnippetRepositoryWizard wizard;
            if (suitableWizardDescriptors.size() == 1) {
                wizard = ((WizardDescriptor)Iterables.getOnlyElement(suitableWizardDescriptors)).getWizard();
                wizard.setConfiguration(oldConfiguration);
            } else {
                wizard = new SnippetRepositoryTypeSelectionWizard(oldConfiguration);
            }
            WizardDialog dialog = new WizardDialog(this.tree.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                EList<SnippetRepositoryConfiguration> configurations = this.configs.getRepos();
                configurations.add(configurations.indexOf(oldConfiguration), wizard.getConfiguration());
                configurations.remove(oldConfiguration);
                RepositoryConfigurations.storeConfigurations(this.configs, this.repositoryConfigurationFile);
                this.bus.post((Object)new Repositories.SnippetRepositoryConfigurationChangedEvent());
                this.refreshUI();
            }
        }
    }

    private void changeEnableStateRepos(boolean enabled) {
        Checks.ensureIsTrue((boolean)this.selectionContainsOnlyOneElementOf(SnippetRepositoryConfiguration.class));
        SnippetRepositoryConfiguration config = (SnippetRepositoryConfiguration)Checks.cast((Object)this.selection.get(0));
        this.prefs.setRepositoryEnabled(config, enabled);
        this.updateActionsStatus();
    }

    private void reload() {
        Job reconnectJob = new Job(Messages.JOB_RECONNECTING_SNIPPET_REPOSITORY){

            protected IStatus run(IProgressMonitor monitor) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SnippetsView.this.refreshAction.setEnabled(false);
                    }
                });
                try {
                    SnippetsView.this.repos.close();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                try {
                    SnippetsView.this.repos.open();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SnippetsView.this.refreshAction.setEnabled(true);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        reconnectJob.schedule();
    }

    private void addSnippet(ISnippetRepository repo) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            Snippet snippet = new Snippet(UUID.randomUUID(), "", "", Collections.emptyList(), Collections.emptyList(), "", Location.NONE);
            SnippetEditorInput input = new SnippetEditorInput((ISnippet)snippet, repo);
            SnippetEditor editor = (SnippetEditor)((Object)Checks.cast((Object)page.openEditor((IEditorInput)input, "org.eclipse.recommenders.snipmatch.rcp.editors.snippet")));
            editor.markDirtyUponSnippetCreation();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void addSnippet() {
        this.addSnippet(null);
    }

    private void removeSnippets() {
        Checks.ensureIsTrue((boolean)this.selectionConsistsOnlyElementsOf(KnownSnippet.class));
        boolean confirmed = MessageDialog.openConfirm((Shell)this.tree.getShell(), (String)Messages.CONFIRM_DIALOG_DELETE_SNIPPET_TITLE, (String)Messages.CONFIRM_DIALOG_DELETE_SNIPPET_MESSAGE);
        if (!confirmed) {
            return;
        }
        List selectedSnippets = this.castSelection();
        for (KnownSnippet knownSnippet : selectedSnippets) {
            try {
                for (ISnippetRepository repo : this.repos.getRepositories()) {
                    repo.delete(knownSnippet.snippet.getUuid());
                }
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    private void editSnippets() {
        Checks.ensureIsTrue((boolean)this.selectionConsistsOnlyElementsOf(KnownSnippet.class));
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        List selectedSnippets = this.castSelection();
        for (KnownSnippet knownSnippet : selectedSnippets) {
            try {
                ISnippet snippet = knownSnippet.snippet;
                ISnippetRepository repository = this.findRepoForOriginalSnippet(snippet);
                SnippetEditorInput input = new SnippetEditorInput(snippet, repository);
                page.openEditor((IEditorInput)input, "org.eclipse.recommenders.snipmatch.rcp.editors.snippet");
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    private void shareSnippets() {
        Checks.ensureIsTrue((boolean)this.selectionIsShareable());
        List selectedSnippets = this.castSelection();
        Optional<ISnippetRepository> repository = this.repos.getRepository(((KnownSnippet)selectedSnippets.get((int)0)).config.getId());
        if (!repository.isPresent()) {
            return;
        }
        Collection uuids = Collections2.transform(selectedSnippets, (Function)new Function<KnownSnippet, UUID>(){

            public UUID apply(KnownSnippet input) {
                return input.snippet.getUuid();
            }
        });
        ((ISnippetRepository)repository.get()).share(uuids);
    }

    private void addToolBar(Composite parent) {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.addAction(Messages.SNIPPETS_VIEW_MENUITEM_ADD_SNIPPET, (SharedImages.ImageResource)SharedImages.Images.ELCL_ADD_SNIPPET, (IContributionManager)toolBarManager, (IAction)this.addSnippetAction);
        this.addAction(Messages.SNIPPETS_VIEW_MENUITEM_ADD_REPOSITORY, (SharedImages.ImageResource)SharedImages.Images.ELCL_ADD_REPOSITORY, (IContributionManager)toolBarManager, (IAction)this.addRepositoryAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.addAction(Messages.TOOLBAR_TOOLTIP_EXPAND_ALL, (SharedImages.ImageResource)SharedImages.Images.ELCL_EXPAND_ALL, (IContributionManager)toolBarManager, (IAction)new Action(){

            public void run() {
                int i = 0;
                while (i < SnippetsView.this.treeViewer.getTree().getItemCount()) {
                    SnippetsView.this.treeViewer.getTree().getItem(i).setExpanded(true);
                    ++i;
                }
            }
        });
        this.addAction(Messages.TOOLBAR_TOOLTIP_COLLAPSE_ALL, (SharedImages.ImageResource)SharedImages.Images.ELCL_COLLAPSE_ALL, (IContributionManager)toolBarManager, (IAction)new Action(){

            public void run() {
                int i = 0;
                while (i < SnippetsView.this.treeViewer.getTree().getItemCount()) {
                    SnippetsView.this.treeViewer.getTree().getItem(i).setExpanded(false);
                    ++i;
                }
            }
        });
        toolBarManager.add((IContributionItem)new Separator());
        this.addAction(Messages.SNIPPETS_VIEW_MENUITEM_REFRESH, (SharedImages.ImageResource)SharedImages.Images.ELCL_REFRESH, (IContributionManager)toolBarManager, (IAction)this.refreshAction);
    }

    private void addContextMenu() {
        MenuManager menuManager = new MenuManager();
        Menu contextMenu = menuManager.createContextMenu((Control)this.tree);
        menuManager.setRemoveAllWhenShown(true);
        this.tree.setMenu(contextMenu);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISnippetRepository repo;
                boolean addedAddSnippetToRepoAction = false;
                SnippetRepositoryConfiguration guessedConfiguration = (SnippetRepositoryConfiguration)SnippetsView.this.guessConfigurationForNewSnippet().orNull();
                if (guessedConfiguration != null && (repo = (ISnippetRepository)SnippetsView.this.repos.getRepository(guessedConfiguration.getId()).orNull()) != null) {
                    SnippetsView.this.addAction(MessageFormat.format(Messages.SNIPPETS_VIEW_MENUITEM_ADD_SNIPPET_TO_REPOSITORY, guessedConfiguration.getName()), (SharedImages.ImageResource)SharedImages.Images.ELCL_ADD_SNIPPET, (IContributionManager)manager, (IAction)new Action(){

                        public void run() {
                            SnippetsView.this.addSnippet(repo);
                        }
                    });
                    addedAddSnippetToRepoAction = true;
                }
                if (!addedAddSnippetToRepoAction) {
                    SnippetsView.this.addAction(Messages.SNIPPETS_VIEW_MENUITEM_ADD_SNIPPET, (SharedImages.ImageResource)SharedImages.Images.ELCL_ADD_SNIPPET, (IContributionManager)manager, (IAction)SnippetsView.this.addSnippetAction);
                }
                if (SnippetsView.this.selectionConsistsOnlyElementsOf(KnownSnippet.class)) {
                    SnippetsView.this.addAction(Messages.SNIPPETS_VIEW_MENUITEM_EDIT_SNIPPET, (SharedImages.ImageResource)SharedImages.Images.ELCL_EDIT_SNIPPET, (IContributionManager)manager, (IAction)SnippetsView.this.editSnippetAction);
                    SnippetsView.this.addAction(Messages.SNIPPETS_VIEW_MENUITEM_REMOVE_SNIPPET, (SharedImages.ImageResource)SharedImages.Images.ELCL_REMOVE_SNIPPET, (IContributionManager)manager, (IAction)SnippetsView.this.removeSnippetAction);
                    SnippetsView.this.addAction(Messages.SNIPPETS_VIEW_MENUITEM_SHARE_SNIPPET, (SharedImages.ImageResource)SharedImages.Images.ELCL_SHARE_SNIPPET, (IContributionManager)manager, (IAction)SnippetsView.this.shareSnippetAction);
                }
                manager.add((IContributionItem)new Separator());
                SnippetsView.this.addAction(Messages.SNIPPETS_VIEW_MENUITEM_ADD_REPOSITORY, (SharedImages.ImageResource)SharedImages.Images.ELCL_ADD_REPOSITORY, (IContributionManager)manager, (IAction)SnippetsView.this.addRepositoryAction);
                if (SnippetsView.this.selectionConsistsOnlyElementsOf(SnippetRepositoryConfiguration.class)) {
                    SnippetsView.this.addAction(Messages.SNIPPETS_VIEW_MENUITEM_EDIT_REPOSITORY, (SharedImages.ImageResource)SharedImages.Images.ELCL_EDIT_REPOSITORY, (IContributionManager)manager, (IAction)SnippetsView.this.editRepositoryAction);
                    SnippetsView.this.addAction(Messages.SNIPPETS_VIEW_MENUITEM_REMOVE_REPOSITORY, SharedImages.Images.ELCL_REMOVE_REPOSITORY, SharedImages.Images.ELCL_REMOVE_REPOSITORY_DISABLED, (IContributionManager)manager, SnippetsView.this.removeRepositoryAction);
                    if (SnippetsView.this.disableRepositoryAction.isEnabled()) {
                        SnippetsView.this.addAction(Messages.SNIPPETS_VIEW_MENUITEM_DISABLE_REPOSITORY, (SharedImages.ImageResource)SharedImages.Images.ELCL_DISABLE_REPOSITORY, (IContributionManager)manager, (IAction)SnippetsView.this.disableRepositoryAction);
                    }
                    if (SnippetsView.this.enableRepositoryAction.isEnabled()) {
                        SnippetsView.this.addAction(Messages.SNIPPETS_VIEW_MENUITEM_ENABLE_REPOSITORY, (SharedImages.ImageResource)SharedImages.Images.ELCL_ENABLE_REPOSITORY, (IContributionManager)manager, (IAction)SnippetsView.this.enableRepositoryAction);
                    }
                }
            }
        });
    }

    protected Optional<SnippetRepositoryConfiguration> guessConfigurationForNewSnippet() {
        if (this.selection.isEmpty()) {
            return Optional.absent();
        }
        SnippetRepositoryConfiguration selectedConfiguration = null;
        if (this.selectionContainsOnlyOneElementOf(SnippetRepositoryConfiguration.class)) {
            selectedConfiguration = (SnippetRepositoryConfiguration)Checks.cast((Object)this.selection.get(0));
        } else if (this.selectionConsistsOnlyElementsOf(KnownSnippet.class)) {
            List selectedSnippets = this.castSelection();
            for (KnownSnippet snippet : selectedSnippets) {
                if (selectedConfiguration == null) {
                    selectedConfiguration = snippet.config;
                    continue;
                }
                if (selectedConfiguration.equals(snippet.config)) continue;
                return Optional.absent();
            }
        }
        return Optional.fromNullable(selectedConfiguration);
    }

    private <T> boolean selectionContainsOnlyOneElementOf(Class<T> aClass) {
        return this.selection != null && this.selection.size() == 1 && aClass.isAssignableFrom(this.selection.get(0).getClass());
    }

    private <T> boolean selectionConsistsOnlyElementsOf(Class<T> aClass) {
        if (this.selection == null || this.selection.isEmpty()) {
            return false;
        }
        for (Object element : this.selection) {
            if (aClass.isAssignableFrom(element.getClass())) continue;
            return false;
        }
        return true;
    }

    private boolean selectionIsShareable() {
        if (this.selection == null || this.selection.isEmpty()) {
            return false;
        }
        if (!this.selectionConsistsOnlyElementsOf(KnownSnippet.class)) {
            return false;
        }
        HashSet configIds = Sets.newHashSet();
        for (Object element : this.selection) {
            KnownSnippet snippet = (KnownSnippet)element;
            String configId = snippet.config.getId();
            configIds.add(configId);
            if (configIds.size() > 1) {
                return false;
            }
            Optional<ISnippetRepository> repository = this.repos.getRepository(configId);
            if (!repository.isPresent()) {
                return false;
            }
            if (((ISnippetRepository)repository.get()).isSharingSupported()) continue;
            return false;
        }
        return true;
    }

    private <T> List<T> castSelection() {
        ArrayList result = Lists.newArrayList();
        for (Object element : this.selection) {
            Object casted = Checks.cast(element);
            result.add(casted);
        }
        return result;
    }

    private void addAction(String text, SharedImages.ImageResource imageResource, IContributionManager contributionManager, IAction action) {
        action.setImageDescriptor(this.images.getDescriptor(imageResource));
        action.setText(text);
        action.setToolTipText(text);
        contributionManager.add(action);
    }

    private void addAction(String text, SharedImages.Images imageResource, SharedImages.Images imageResourceDisabled, IContributionManager contributionManager, Action action) {
        action.setDisabledImageDescriptor(this.images.getDescriptor((SharedImages.ImageResource)imageResourceDisabled));
        this.addAction(text, (SharedImages.ImageResource)imageResource, contributionManager, (IAction)action);
    }

    @Subscribe
    public void onEvent(SnippetRepositoryOpenedEvent e) throws IOException {
        this.refreshUI();
    }

    @Subscribe
    public void onEvent(SnippetRepositoryClosedEvent e) throws IOException {
        this.refreshUI();
    }

    private boolean isImportSupported() {
        for (ISnippetRepository repo : this.repos.getRepositories()) {
            if (!repo.isImportSupported()) continue;
            return true;
        }
        return false;
    }

    @Subscribe
    public void onEvent(SnippetRepositoryContentChangedEvent e) throws IOException {
        this.refreshUI();
    }

    private void refreshUI() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Job.getJobManager().cancel((Object)"SEARCH_JOB_FAMILY");
                Job.getJobManager().cancel((Object)"REFRESH_TABLE_JOB_FAMILY");
                String query = SnippetsView.this.txtSearch.isDisposed() ? "" : SnippetsView.this.txtSearch.getText();
                SearchJob searchSnippetsJob = new SearchJob(Messages.JOB_SEARCHING_SNIPPET_REPOSITORIES, query);
                RefreshTableJob refreshTableJob = new RefreshTableJob(Messages.JOB_REFRESHING_SNIPPETS_VIEW);
                Jobs.sequential((String)Messages.JOB_GROUP_UPDATING_SNIPPETS_VIEW, (Job[])new Job[]{searchSnippetsJob, refreshTableJob});
            }
        });
    }

    private ISnippetRepository findRepoForOriginalSnippet(ISnippet snippet) {
        for (ISnippetRepository repo : this.repos.getRepositories()) {
            if (!repo.hasSnippet(snippet.getUuid())) continue;
            return repo;
        }
        return null;
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public class KnownSnippet {
        public ISnippet snippet;
        public SnippetRepositoryConfiguration config;

        public KnownSnippet(SnippetRepositoryConfiguration config, ISnippet snippet) {
            this.config = config;
            this.snippet = snippet;
        }
    }

    private final class RefreshTableJob
    extends UIJob {
        public static final String REFRESH_TABLE_JOB_FAMILY = "REFRESH_TABLE_JOB_FAMILY";

        private RefreshTableJob(String name) {
            super(name);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                if (!SnippetsView.this.treeViewer.getControl().isDisposed()) {
                    if (SnippetsView.this.initializeTableData) {
                        SnippetsView.this.treeViewer.setInput((Object)SnippetsView.this.getViewSite());
                        SnippetsView.this.initializeTableData = false;
                    } else {
                        this.refreshTable(monitor);
                    }
                }
                SnippetsView.this.addSnippetAction.setEnabled(SnippetsView.this.isImportSupported());
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }

        private void refreshTable(IProgressMonitor monitor) {
            int numberOfVisibleElements = ((SnippetsView)SnippetsView.this).treeViewer.getTree().getSize().y / SnippetsView.this.treeViewer.getTree().getItemHeight() + 1;
            try {
                monitor.beginTask(Messages.MONITOR_REFRESHING_TABLE, SnippetsView.this.availableRepositories.size());
                SnippetsView.this.treeViewer.refresh();
                int replacedElementsCount = 0;
                int i = 0;
                while (i < SnippetsView.this.availableRepositories.size()) {
                    SnippetRepositoryConfiguration config = (SnippetRepositoryConfiguration)SnippetsView.this.availableRepositories.get(i);
                    List elements = SnippetsView.this.filteredSnippetsGroupedByRepoName.get((Object)config);
                    SnippetsView.this.treeViewer.setChildCount((Object)config, elements.size());
                    int j = 0;
                    while (j < elements.size() && replacedElementsCount < numberOfVisibleElements) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        SnippetsView.this.treeViewer.replace((Object)config, j, elements.get(j));
                        ++replacedElementsCount;
                        ++j;
                    }
                    monitor.worked(1);
                    ++i;
                }
            }
            finally {
                monitor.done();
            }
        }

        public boolean belongsTo(Object family) {
            return REFRESH_TABLE_JOB_FAMILY.equals(family);
        }
    }

    private final class SearchJob
    extends Job {
        public static final String SEARCH_JOB_FAMILY = "SEARCH_JOB_FAMILY";
        private final String query;

        private SearchJob(String name, String query) {
            super(name);
            this.query = query;
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask(Messages.MONITOR_SEARCH_SNIPPETS, 30);
                SnippetsView.this.snippetsGroupedByRepoName = this.searchSnippets("", (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                SnippetsView.this.filteredSnippetsGroupedByRepoName = this.searchSnippets(this.query, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                SnippetsView.this.availableRepositories = SnippetsView.this.configs.getRepos();
                monitor.worked(10);
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }

        private ListMultimap<SnippetRepositoryConfiguration, KnownSnippet> searchSnippets(String searchTerm, IProgressMonitor monitor) {
            try {
                LinkedListMultimap snippetsGroupedByRepositoryName = LinkedListMultimap.create();
                monitor.beginTask(Messages.MONITOR_SEARCH_SNIPPETS, SnippetsView.this.configs.getRepos().size());
                for (SnippetRepositoryConfiguration config : SnippetsView.this.configs.getRepos()) {
                    if (monitor.isCanceled()) {
                        LinkedListMultimap linkedListMultimap = snippetsGroupedByRepositoryName;
                        return linkedListMultimap;
                    }
                    ISnippetRepository repo = (ISnippetRepository)SnippetsView.this.repos.getRepository(config.getId()).orNull();
                    if (repo == null) continue;
                    HashSet knownSnippets = Sets.newHashSet();
                    for (Recommendation recommendation : repo.search((ISearchContext)new SearchContext(searchTerm.trim()))) {
                        if (monitor.isCanceled()) {
                            LinkedListMultimap linkedListMultimap = snippetsGroupedByRepositoryName;
                            return linkedListMultimap;
                        }
                        knownSnippets.add(new KnownSnippet(config, (ISnippet)recommendation.getProposal()));
                    }
                    List sorted = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).onResultOf(SnippetsView.this.toStringRepresentation).sortedCopy((Iterable)knownSnippets);
                    snippetsGroupedByRepositoryName.putAll((Object)config, (Iterable)sorted);
                    monitor.worked(1);
                }
                LinkedListMultimap linkedListMultimap = snippetsGroupedByRepositoryName;
                return linkedListMultimap;
            }
            finally {
                monitor.done();
            }
        }

        public boolean belongsTo(Object family) {
            return SEARCH_JOB_FAMILY.equals(family);
        }
    }
}

