/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.testing.jayes;

import java.util.Arrays;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.transformation.util.ArrayFlatten;
import org.eclipse.recommenders.testing.jayes.ArrayUtils;

public final class NetExamples {
    private NetExamples() {
        throw new IllegalStateException("Not meant to be instantiated");
    }

    public static BayesNet testNet1() {
        BayesNet net = new BayesNet();
        BayesNode a = net.createNode("a");
        a.addOutcomes(new String[]{"true", "false"});
        a.setProbabilities(new double[]{0.2, 0.8});
        BayesNode b = net.createNode("b");
        b.addOutcomes(new String[]{"la", "le", "lu"});
        b.setParents(Arrays.asList(a));
        b.setProbabilities(ArrayFlatten.flatten((double[][])new double[][]{{0.1, 0.4, 0.5}, {0.3, 0.4, 0.3}}));
        BayesNode c = net.createNode("c");
        c.addOutcomes(new String[]{"true", "false"});
        c.setParents(Arrays.asList(a, b));
        c.setProbabilities(ArrayUtils.flatten(new double[][][]{new double[][]{{0.1, 0.9}, {0.0, 1.0}, {0.5, 0.5}}, new double[][]{{0.2, 0.8}, {0.0, 1.0}, {0.7, 0.3}}}));
        BayesNode d = net.createNode("d");
        d.addOutcomes(new String[]{"true", "false"});
        d.setParents(Arrays.asList(c));
        d.setProbabilities(ArrayFlatten.flatten((double[][])new double[][]{{0.5, 0.5}, {0.2, 0.8}}));
        return net;
    }

    public static BayesNet unconnectedNet() {
        BayesNet net = new BayesNet();
        BayesNode a = net.createNode("a");
        BayesNode b = net.createNode("b");
        a.addOutcomes(new String[]{"true", "false"});
        b.addOutcomes(new String[]{"true", "false"});
        a.setProbabilities(new double[]{0.4, 0.6});
        b.setProbabilities(new double[]{0.55, 0.45});
        return net;
    }

    public static BayesNet sparseNet() {
        BayesNet net = new BayesNet();
        BayesNode a = net.createNode("a");
        a.addOutcome("true");
        a.addOutcome("false");
        a.setProbabilities(new double[]{0.0, 1.0});
        BayesNode b = net.createNode("b");
        b.addOutcomes(new String[]{"la", "le", "lu"});
        b.setParents(Arrays.asList(a));
        b.setProbabilities(ArrayFlatten.flatten((double[][])new double[][]{{0.1, 0.4, 0.5}, {0.3, 0.4, 0.3}}));
        BayesNode c = net.createNode("c");
        c.addOutcomes(new String[]{"true", "false", "sth", "sthElse"});
        c.setParents(Arrays.asList(a, b));
        c.setProbabilities(ArrayUtils.flatten(new double[][][]{new double[][]{{0.0, 0.0, 0.1, 0.9}, {0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0}}, new double[][]{{0.0, 0.5, 0.0, 0.5}, {0.0, 0.0, 0.0, 1.0}, {0.0, 0.7, 0.3, 0.0}}}));
        BayesNode d = net.createNode("d");
        d.addOutcomes(new String[]{"true", "false"});
        d.setParents(Arrays.asList(c));
        d.setProbabilities(ArrayFlatten.flatten((double[][])new double[][]{{0.5, 0.5}, {0.2, 0.8}, {0.5, 0.5}, {0.0, 1.0}}));
        return net;
    }

    public static BayesNet treeNet() {
        BayesNet net = new BayesNet();
        BayesNode a = net.createNode("a");
        a.addOutcomes(new String[]{"true", "false"});
        BayesNode b = net.createNode("b");
        b.addOutcomes(new String[]{"true", "false"});
        b.setParents(Arrays.asList(a));
        BayesNode c = net.createNode("c");
        c.addOutcomes(new String[]{"true", "false"});
        c.setParents(Arrays.asList(a));
        BayesNode d = net.createNode("d");
        d.addOutcomes(new String[]{"true", "false"});
        d.setParents(Arrays.asList(a));
        a.setProbabilities(new double[]{0.4, 0.6});
        b.setProbabilities(new double[]{0.55, 0.45, 0.45, 0.55});
        c.setProbabilities(new double[]{0.55, 0.45, 0.45, 0.55});
        d.setProbabilities(new double[]{0.55, 0.45, 0.45, 0.55});
        return net;
    }
}

