/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.recommenders.utils.LogMessages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.IPackageName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class Zips {
    public static ZipFile NULL() {
        try {
            File tmp = File.createTempFile("recommenders_null_zip", ".zip");
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tmp));
            zos.putNextEntry(new ZipEntry("/"));
            zos.closeEntry();
            zos.close();
            return new ZipFile(tmp);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void unzip(File zipFile, File destFolder) throws IOException {
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            InputSupplier fis = Files.newInputStreamSupplier((File)zipFile);
            zis = new ZipInputStream((InputStream)fis.getInput());
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                File file = new File(destFolder, entry.getName());
                Files.createParentDirs((File)file);
                Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).writeFrom((InputStream)zis);
            }
        }
        catch (Throwable throwable) {
            Closeables.close(zis, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)zis, (boolean)true);
    }

    public static void zip(File directory, File out) throws IOException {
        ZipOutputStream zos = null;
        try {
            OutputSupplier s = Files.newOutputStreamSupplier((File)out);
            zos = new ZipOutputStream((OutputStream)s.getOutput());
            for (File f : FileUtils.listFiles((File)directory, (IOFileFilter)FileFileFilter.FILE, (IOFileFilter)DirectoryFileFilter.DIRECTORY)) {
                String path = StringUtils.removeStart((String)f.getPath(), (String)(String.valueOf(directory.getAbsolutePath()) + File.separator));
                path = path.replace(File.separatorChar, '/');
                ZipEntry e = new ZipEntry(path);
                zos.putNextEntry(e);
                Files.asByteSource((File)f).copyTo((OutputStream)zos);
                zos.closeEntry();
            }
        }
        catch (Throwable throwable) {
            Closeables.close(zos, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)zos, (boolean)false);
    }

    public static String path(ITypeName type, String suffix) {
        String name = StringUtils.removeStart((String)type.getIdentifier(), (String)"L");
        return suffix == null ? name : String.valueOf(name) + suffix;
    }

    public static String path(IPackageName pkg, String suffix) {
        String name = pkg.getIdentifier();
        return suffix == null ? name : String.valueOf(name) + suffix;
    }

    public static Set<ITypeName> types(ZipFile zip, String suffix) {
        return Zips.types(zip.entries(), suffix);
    }

    public static Set<ITypeName> types(Enumeration<? extends ZipEntry> entries, String suffix) {
        TreeSet content = Sets.newTreeSet();
        while (entries.hasMoreElements()) {
            ZipEntry next = entries.nextElement();
            if (next.isDirectory() || next.getName().startsWith("META-INF/")) continue;
            ITypeName type = Zips.type(next, suffix);
            content.add(type);
        }
        return content;
    }

    public static ITypeName type(ZipEntry entry, String suffix) {
        String name = StringUtils.removeEnd((String)entry.getName(), (String)suffix);
        return VmTypeName.get("L" + name);
    }

    public static Set<IMethodName> methods(ZipFile zip, String suffix) {
        return Zips.methods(zip.entries(), suffix);
    }

    public static Set<IMethodName> methods(Enumeration<? extends ZipEntry> entries, String suffix) {
        TreeSet content = Sets.newTreeSet();
        while (entries.hasMoreElements()) {
            ZipEntry next = entries.nextElement();
            if (next.isDirectory() || next.getName().startsWith("META-INF/")) continue;
            IMethodName type = Zips.method(next, suffix);
            content.add(type);
        }
        return content;
    }

    public static IMethodName method(ZipEntry e, String suffix) {
        String name = "L" + StringUtils.substringBefore((String)e.getName(), (String)suffix);
        int start = name.lastIndexOf(47);
        char[] chars = name.toCharArray();
        chars[start] = 46;
        int i = start + 1;
        while (i < chars.length) {
            if (chars[i] == '.') {
                chars[i] = 47;
            }
            ++i;
        }
        return VmMethodName.get(new String(chars));
    }

    public static String path(IMethodName method, String suffix) {
        ITypeName type = method.getDeclaringType();
        String name = String.valueOf(Zips.path(type, null)) + "/" + method.getSignature().replaceAll("/", ".");
        return suffix == null ? name : String.valueOf(name) + suffix;
    }

    public static void append(ZipOutputStream zos, String path, String data) throws IOException {
        ZipEntry e = new ZipEntry(path);
        zos.putNextEntry(e);
        zos.write(data.getBytes(Charsets.UTF_8));
        zos.closeEntry();
    }

    public static byte[] readFully(File file) throws IOException {
        return ByteStreams.toByteArray((InputSupplier)Files.newInputStreamSupplier((File)file));
    }

    public static boolean closeQuietly(ZipFile z) {
        if (z == null) {
            return true;
        }
        try {
            z.close();
            return true;
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_CANNOT_CLOSE_RESOURCE, e, z.getName());
            return false;
        }
    }

    public static class DefaultJarFileConverter
    implements IFileToJarFileConverter {
        @Override
        public Optional<JarFile> createJarFile(File file) {
            try {
                return Optional.of((Object)new JarFile(file));
            }
            catch (IOException iOException) {
                return Optional.absent();
            }
        }
    }

    @VisibleForTesting
    public static interface IFileToJarFileConverter {
        public Optional<JarFile> createJarFile(File var1);
    }
}

