/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.names;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.recommenders.utils.names.IPackageName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class VmPackageName
implements IPackageName {
    private static final Map<String, VmPackageName> INDEX = new MapMaker().weakValues().makeMap();
    public static final IPackageName DEFAULT_PACKAGE = VmPackageName.get("");
    private final String identifier;

    public static synchronized VmPackageName get(String vmPackageName) {
        VmPackageName res = INDEX.get(vmPackageName);
        if (res == null) {
            res = new VmPackageName(vmPackageName);
            INDEX.put(vmPackageName, res);
        }
        return res;
    }

    public static Set<IPackageName> packages(Set<ITypeName> types) {
        TreeSet res = Sets.newTreeSet();
        for (ITypeName type : types) {
            res.add(type.getPackage());
        }
        return res;
    }

    @VisibleForTesting
    protected VmPackageName(String vmPackageName) {
        this.identifier = vmPackageName;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isDefaultPackage() {
        return this.getIdentifier().isEmpty();
    }

    @Override
    public int compareTo(IPackageName o) {
        return this.getIdentifier().compareTo(o.getIdentifier());
    }

    public String toString() {
        return this.getIdentifier();
    }
}

