/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.ui.IEditorPart;

@Beta
public final class CompletionContexts {
    public static final String JDT_ALL_CATEGORY = "org.eclipse.jdt.ui.javaAllProposalCategory";
    public static final String MYLYN_ALL_CATEGORY = "org.eclipse.mylyn.java.ui.javaAllProposalCategory";

    private CompletionContexts() {
    }

    public static String getPrefixMatchingArea(String displayString) {
        displayString = CompletionContexts.stripHtmlTagDelimiters(displayString);
        int end = displayString.length();
        int i = 0;
        while (i < displayString.length()) {
            char c = displayString.charAt(i);
            if (!CompletionContexts.isJavaIdentifierLike(c) && c != '.') {
                end = i;
                break;
            }
            ++i;
        }
        return displayString.substring(0, end);
    }

    private static String stripHtmlTagDelimiters(String string) {
        if (string.startsWith("<") && string.endsWith(">")) {
            boolean isClosingTag = string.charAt(1) == '/';
            return string.substring(isClosingTag ? 2 : 1, string.length() - 1);
        }
        return string;
    }

    private static boolean isJavaIdentifierLike(char c) {
        return Character.isJavaIdentifierPart(c) || c == '@' || c == '{' || c == '}';
    }

    public static boolean isMylynInstalled() {
        CompletionProposalComputerRegistry reg = CompletionProposalComputerRegistry.getDefault();
        for (CompletionProposalCategory cat : reg.getProposalCategories()) {
            if (!cat.getId().equals(MYLYN_ALL_CATEGORY)) continue;
            return true;
        }
        return false;
    }

    public static JavaContentAssistInvocationContext toContentAssistInvocationContext(IInvocationContext context) {
        Checks.ensureIsNotNull((Object)context);
        return new QuickFixToContentAssistContextFunction().apply(context);
    }

    public static Optional<JavaContentAssistInvocationContext> newContentAssistInvocationContext(IEditorPart editor) {
        if (editor instanceof JavaEditor) {
            JavaEditor ed = (JavaEditor)editor;
            ISourceViewer viewer = ed.getViewer();
            int offset = viewer.getTextWidget().getCaretOffset();
            return Optional.of((Object)new JavaContentAssistInvocationContext((ITextViewer)viewer, offset, (IEditorPart)ed));
        }
        return Optional.absent();
    }

    static final class QuickFixToContentAssistContextFunction
    implements Function<IInvocationContext, JavaContentAssistInvocationContext> {
        private CompletionContext internalContext;

        QuickFixToContentAssistContextFunction() {
        }

        public JavaContentAssistInvocationContext apply(IInvocationContext context) {
            ICompilationUnit cu = context.getCompilationUnit();
            int offset = context.getSelectionOffset();
            try {
                cu.codeComplete(offset, new CompletionRequestor(){

                    public void acceptContext(CompletionContext context) {
                        QuickFixToContentAssistContextFunction.this.internalContext = context;
                    }

                    public boolean isExtendedContextRequired() {
                        return true;
                    }

                    public void accept(CompletionProposal proposal) {
                    }
                });
            }
            catch (JavaModelException e) {
                Throwables.propagate((Throwable)e);
            }
            JavaEditor editor = (JavaEditor)Checks.cast((Object)EditorUtility.isOpenInEditor((Object)cu));
            ISourceViewer viewer = editor.getViewer();
            return new JavaContentAssistInvocationContext((ITextViewer)viewer, offset, (IEditorPart)editor){

                public CompletionContext getCoreContext() {
                    return QuickFixToContentAssistContextFunction.this.internalContext;
                }
            };
        }
    }
}

