/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.Proposals;
import org.eclipse.recommenders.internal.completion.rcp.l10n.Messages;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class ProcessableFilledArgumentNamesMethodProposal
extends JavaMethodCompletionProposal
implements IProcessableProposal {
    private Map<IProposalTag, Object> tags = Maps.newHashMap();
    private IRegion fSelectedRegion;
    private int[] fArgumentOffsets;
    private int[] fArgumentLengths;
    private String lastPrefix;
    private String lastPrefixStyled;
    private StyledString initialDisplayString;
    private CompletionProposal coreProposal;
    private ProposalProcessorManager mgr;

    public ProcessableFilledArgumentNamesMethodProposal(CompletionProposal coreProposal, JavaContentAssistInvocationContext context) {
        super(coreProposal, context);
        this.coreProposal = coreProposal;
    }

    public void apply(IDocument document, char trigger, int offset) {
        super.apply(document, trigger, offset);
        int baseOffset = this.getReplacementOffset();
        String replacement = this.getReplacementString();
        if (this.fArgumentOffsets != null && this.getTextViewer() != null) {
            try {
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i != this.fArgumentOffsets.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, baseOffset + this.fArgumentOffsets[i], this.fArgumentLengths[i], -1));
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                JavaEditor editor = this.getJavaEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), baseOffset + replacement.length(), 0, Integer.MAX_VALUE);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractJavaCompletionProposal.ExitPolicy(')', document));
                ui.setDoContextInfo(true);
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            }
            catch (BadLocationException e) {
                JavaPlugin.log((Throwable)e);
                this.openErrorDialog(e);
            }
        } else {
            this.fSelectedRegion = new Region(baseOffset + replacement.length(), 0);
        }
    }

    protected boolean needsLinkedMode() {
        return false;
    }

    protected String computeReplacementString() {
        if (!this.hasParameters() || !this.hasArgumentList()) {
            return super.computeReplacementString();
        }
        StringBuffer buffer = new StringBuffer();
        this.appendMethodNameReplacement(buffer);
        char[][] parameterNames = this.fProposal.findParameterNames(null);
        int count = parameterNames.length;
        this.fArgumentOffsets = new int[count];
        this.fArgumentLengths = new int[count];
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        this.setCursorPosition(buffer.length());
        if (prefs.afterOpeningParen) {
            buffer.append(" ");
        }
        int i = 0;
        while (i != count) {
            if (i != 0) {
                if (prefs.beforeComma) {
                    buffer.append(" ");
                }
                buffer.append(",");
                if (prefs.afterComma) {
                    buffer.append(" ");
                }
            }
            this.fArgumentOffsets[i] = buffer.length();
            buffer.append(parameterNames[i]);
            this.fArgumentLengths[i] = parameterNames[i].length;
            ++i;
        }
        if (prefs.beforeClosingParen) {
            buffer.append(" ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(BadLocationException e) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)Messages.DIALOG_TITLE_FAILED_TO_GUESS_PARAMETERS, (String)e.getMessage());
    }

    protected Image computeImage() {
        Image image = super.computeImage();
        return this.mgr.decorateImage(image);
    }

    @Override
    public StyledString getStyledDisplayString() {
        StyledString decorated;
        StyledString copy;
        if (this.initialDisplayString == null) {
            this.initialDisplayString = super.getStyledDisplayString();
            copy = Proposals.copyStyledString(this.initialDisplayString);
            decorated = this.mgr.decorateStyledDisplayString(copy);
            this.setStyledDisplayString(decorated);
        }
        if (this.lastPrefixStyled != this.lastPrefix) {
            this.lastPrefixStyled = this.lastPrefix;
            copy = Proposals.copyStyledString(this.initialDisplayString);
            decorated = this.mgr.decorateStyledDisplayString(copy);
            this.setStyledDisplayString(decorated);
        }
        return super.getStyledDisplayString();
    }

    public boolean isPrefix(String prefix, String completion) {
        this.lastPrefix = prefix;
        boolean res = this.mgr.prefixChanged(prefix) || super.isPrefix(prefix, completion);
        this.setTag(ProposalTag.IS_VISIBLE, res);
        return res;
    }

    @Override
    public String getPrefix() {
        return this.lastPrefix;
    }

    @Override
    public Optional<CompletionProposal> getCoreProposal() {
        return Optional.fromNullable((Object)this.coreProposal);
    }

    @Override
    public ProposalProcessorManager getProposalProcessorManager() {
        return this.mgr;
    }

    @Override
    public void setProposalProcessorManager(ProposalProcessorManager mgr) {
        this.mgr = mgr;
    }

    @Override
    public void setTag(IProposalTag key, Object value) {
        Checks.ensureIsNotNull((Object)key);
        if (value == null) {
            this.tags.remove(key);
        } else {
            this.tags.put(key, value);
        }
    }

    @Override
    public <T> Optional<T> getTag(IProposalTag key) {
        return Optional.fromNullable((Object)this.tags.get(key));
    }

    @Override
    public <T> Optional<T> getTag(String key) {
        return Proposals.getTag((ICompletionProposal)this, key);
    }

    @Override
    public <T> T getTag(IProposalTag key, T defaultValue) {
        Object res = this.tags.get(key);
        return (T)(res != null ? res : defaultValue);
    }

    @Override
    public <T> T getTag(String key, T defaultValue) {
        return (T)this.getTag(key).or(defaultValue);
    }

    @Override
    public ImmutableSet<IProposalTag> tags() {
        return ImmutableSet.copyOf(this.tags.keySet());
    }
}

