/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.ui.text.java.FillArgumentNamesCompletionProposalCollector;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.recommenders.internal.completion.rcp.l10n.LogMessages;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Reflections;
import org.eclipse.swt.graphics.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProposalCollectingCompletionRequestor
extends CompletionRequestor {
    private static final Field F_PROPOSALS = (Field)Reflections.getDeclaredField(CompletionProposalCollector.class, (String)"fJavaProposals").orNull();
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Map<IJavaCompletionProposal, CompletionProposal> proposals = Maps.newIdentityHashMap();
    private JavaContentAssistInvocationContext jdtuiContext;
    private CompletionProposalCollector collector;
    private InternalCompletionContext compilerContext;

    public ProposalCollectingCompletionRequestor(JavaContentAssistInvocationContext ctx) {
        super(false);
        Preconditions.checkNotNull((Object)ctx);
        this.jdtuiContext = ctx;
        this.initalizeCollector();
    }

    private void initalizeCollector() {
        this.collector = this.shouldFillArgumentNames() ? new FillArgumentNamesCompletionProposalCollector(this.jdtuiContext) : new CompletionProposalCollector(this.jdtuiContext.getCompilationUnit(), false);
        this.configureInterestedProposalTypes();
        this.adjustProposalReplacementLength();
    }

    private void configureInterestedProposalTypes() {
        this.collector.setIgnored(13, false);
        this.collector.setIgnored(1, false);
        this.collector.setIgnored(27, false);
        this.collector.setIgnored(2, false);
        this.collector.setIgnored(25, false);
        this.collector.setIgnored(3, false);
        this.collector.setIgnored(4, false);
        this.collector.setIgnored(5, false);
        this.collector.setIgnored(7, false);
        this.collector.setIgnored(12, false);
        this.collector.setIgnored(6, false);
        this.collector.setIgnored(26, false);
        this.collector.setIgnored(24, false);
        this.collector.setIgnored(8, false);
        this.collector.setIgnored(11, false);
        this.collector.setIgnored(10, false);
        this.collector.setIgnored(9, false);
        this.collector.setIgnored(19, false);
        this.collector.setIgnored(14, false);
        this.collector.setIgnored(20, false);
        this.collector.setIgnored(15, false);
        this.collector.setIgnored(18, false);
        this.collector.setIgnored(16, false);
        this.collector.setIgnored(17, false);
        this.collector.setAllowsRequiredProposals(2, 9, true);
        this.collector.setAllowsRequiredProposals(2, 23, true);
        this.collector.setAllowsRequiredProposals(2, 21, true);
        this.collector.setAllowsRequiredProposals(6, 9, true);
        this.collector.setAllowsRequiredProposals(6, 23, true);
        this.collector.setAllowsRequiredProposals(6, 22, true);
        this.collector.setAllowsRequiredProposals(26, 9, true);
        this.collector.setAllowsRequiredProposals(27, 9, true);
        this.collector.setAllowsRequiredProposals(1, 9, true);
        this.collector.setAllowsRequiredProposals(9, 9, true);
        this.collector.setFavoriteReferences(this.getFavoriteStaticMembers());
        this.collector.setRequireExtendedContext(true);
    }

    public boolean isIgnored(int completionProposalKind) {
        return this.collector.isIgnored(completionProposalKind);
    }

    public boolean isAllowingRequiredProposals(int proposalKind, int requiredProposalKind) {
        return this.collector.isAllowingRequiredProposals(proposalKind, requiredProposalKind);
    }

    public boolean isExtendedContextRequired() {
        return this.collector.isExtendedContextRequired();
    }

    public String[] getFavoriteReferences() {
        return this.collector.getFavoriteReferences();
    }

    private void adjustProposalReplacementLength() {
        ITextViewer viewer = this.jdtuiContext.getViewer();
        Point selection = viewer.getSelectedRange();
        if (selection.y > 0) {
            this.collector.setReplacementLength(selection.y);
        }
    }

    @VisibleForTesting
    protected boolean shouldFillArgumentNames() {
        try {
            return PreferenceConstants.getPreferenceStore().getBoolean("content_assist_fill_method_arguments");
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void acceptContext(CompletionContext context) {
        this.compilerContext = (InternalCompletionContext)Checks.cast((Object)context);
        this.collector.acceptContext(context);
    }

    private String[] getFavoriteStaticMembers() {
        String serializedFavorites = PreferenceConstants.getPreferenceStore().getString("content_assist_favorite_static_members");
        if (serializedFavorites != null && serializedFavorites.length() > 0) {
            return serializedFavorites.split(";");
        }
        return CharOperation.NO_STRINGS;
    }

    public void accept(CompletionProposal compilerProposal) {
        IJavaCompletionProposal[] iJavaCompletionProposalArray = this.createJdtProposals(compilerProposal);
        int n = iJavaCompletionProposalArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaCompletionProposal uiProposal = iJavaCompletionProposalArray[n2];
            this.proposals.put(uiProposal, compilerProposal);
            ++n2;
        }
    }

    private IJavaCompletionProposal[] createJdtProposals(CompletionProposal proposal) {
        if (F_PROPOSALS != null) {
            try {
                List list = (List)F_PROPOSALS.get(this.collector);
                int oldSize = list.size();
                this.collector.accept(proposal);
                int newSize = list.size();
                List res = list.subList(oldSize, newSize);
                return (IJavaCompletionProposal[])Iterables.toArray(res, IJavaCompletionProposal.class);
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_EXCEPTION_DURING_CODE_COMPLETION, (Throwable)e);
            }
        }
        int oldSize = this.collector.getJavaCompletionProposals().length;
        this.collector.accept(proposal);
        Object[] jdtProposals = this.collector.getJavaCompletionProposals();
        return (IJavaCompletionProposal[])ArrayUtils.subarray((Object[])jdtProposals, (int)oldSize, (int)jdtProposals.length);
    }

    public void setReplacementLength(int y) {
        this.collector.setReplacementLength(y);
    }

    public InternalCompletionContext getCoreContext() {
        return this.compilerContext;
    }

    public Map<IJavaCompletionProposal, CompletionProposal> getProposals() {
        return this.proposals;
    }

    public void completionFailure(IProblem problem) {
        this.log.debug(problem.toString());
    }
}

