/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessorDescriptor;
import org.eclipse.recommenders.internal.completion.rcp.CompletionRcpPreferences;
import org.eclipse.recommenders.internal.completion.rcp.l10n.Messages;
import org.eclipse.recommenders.rcp.utils.ContentAssistEnablementBlock;
import org.eclipse.recommenders.rcp.utils.Selections;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CompletionsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private final CompletionRcpPreferences preferences;

    @Inject
    public CompletionsPreferencePage(CompletionRcpPreferences preferences) {
        super(1);
        this.preferences = preferences;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.completion.rcp"));
        this.setMessage(Messages.PREFPAGE_TITLE_COMPLETIONS);
        this.setDescription(Messages.PREFPAGE_DESCRIPTION_COMPLETIONS);
    }

    protected void createFieldEditors() {
        this.addField(new SessionProcessorEditor("sessionprocessors", Messages.FIELD_LABEL_SESSION_PROCESSORS, this.getFieldEditorParent()));
        this.addField(new ContentAssistEnablementEditor("org.eclipse.recommenders.completion.rcp.proposalCategory.intelligent", "enablement", this.getFieldEditorParent()));
    }

    private final class ContentAssistEnablementEditor
    extends FieldEditor {
        public ContentAssistEnablementEditor(String recommendersAllCategoryId, String string, Composite fieldEditorParent) {
            super(recommendersAllCategoryId, string, fieldEditorParent);
        }

        protected void adjustForNumColumns(int numColumns) {
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            ContentAssistEnablementBlock enable = new ContentAssistEnablementBlock(parent, Messages.FIELD_LABEL_ENABLE_COMPLETION, "org.eclipse.recommenders.completion.rcp.proposalCategory.intelligent"){

                protected void additionalExcludedCompletionCategoriesUpdates(boolean isEnabled, Set<String> cats) {
                    if (isEnabled) {
                        cats.add("org.eclipse.jdt.ui.javaAllProposalCategory");
                        cats.add("org.eclipse.mylyn.java.ui.javaAllProposalCategory");
                    } else if (1.isMylynInstalled()) {
                        cats.remove("org.eclipse.mylyn.java.ui.javaAllProposalCategory");
                    } else {
                        cats.remove("org.eclipse.jdt.ui.javaAllProposalCategory");
                    }
                }

                public void loadSelection() {
                    Object[] excluded = PreferenceConstants.getExcludedCompletionProposalCategories();
                    boolean deactivated = ArrayUtils.contains((Object[])excluded, (Object)"org.eclipse.recommenders.completion.rcp.proposalCategory.intelligent");
                    boolean mylynActive = 1.isMylynInstalled() && !ArrayUtils.contains((Object[])excluded, (Object)"org.eclipse.mylyn.java.ui.javaAllProposalCategory");
                    boolean jdtActive = !ArrayUtils.contains((Object[])excluded, (Object)"org.eclipse.jdt.ui.javaAllProposalCategory");
                    this.enablement.setSelection(!deactivated && !mylynActive && !jdtActive);
                    this.enablement.setToolTipText(Messages.FIELD_TOOLTIP_ENABLE_COMPLETION);
                }
            };
            enable.loadSelection();
            Link contentAssistLink = new Link(parent, 64);
            contentAssistLink.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).align(4, 1).grab(true, false).hint(super.convertHorizontalDLUsToPixels((Control)contentAssistLink, 300), -1).create());
            contentAssistLink.setText(Messages.PREFPAGE_FOOTER_COMPLETIONS);
            contentAssistLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)CompletionsPreferencePage.this.getShell(), (String)"org.eclipse.jdt.ui.preferences.CodeAssistPreferenceAdvanced", null, null);
                }
            });
        }

        protected void doLoad() {
        }

        protected void doLoadDefault() {
        }

        protected void doStore() {
        }

        public int getNumberOfControls() {
            return 0;
        }
    }

    private final class SessionProcessorEditor
    extends FieldEditor {
        private CheckboxTableViewer tableViewer;
        private Composite buttonBox;
        private Button configureBtn;

        private SessionProcessorEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void adjustForNumColumns(int numColumns) {
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            Label control = this.getLabelControl(parent);
            GridDataFactory.swtDefaults().span(numColumns, 1).applyTo((Control)control);
            this.tableViewer = this.getTableControl(parent);
            GridDataFactory.fillDefaults().align(4, 4).span(numColumns - 1, 1).grab(true, false).applyTo((Control)this.tableViewer.getTable());
            this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SessionProcessorEditor.this.updateButtonStatus();
                    SessionProcessorEditor.this.setPresentsDefaultValue(false);
                }
            });
            this.buttonBox = this.getButtonControl(parent);
            GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.buttonBox);
        }

        private CheckboxTableViewer getTableControl(Composite parent) {
            CheckboxTableViewer tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)67584);
            tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    SessionProcessorDescriptor descriptor = (SessionProcessorDescriptor)Checks.cast((Object)element);
                    return descriptor.getName();
                }

                public String getToolTipText(Object element) {
                    SessionProcessorDescriptor descriptor = (SessionProcessorDescriptor)Checks.cast((Object)element);
                    return descriptor.getDescription();
                }

                public Image getImage(Object element) {
                    SessionProcessorDescriptor descriptor = (SessionProcessorDescriptor)Checks.cast((Object)element);
                    return descriptor.getIcon();
                }
            });
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
            tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            tableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    SessionProcessorEditor.this.openSessionProcessorPreferencePage(event.getSelection());
                }
            });
            return tableViewer;
        }

        private Composite getButtonControl(Composite parent) {
            Composite box = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().applyTo(box);
            this.configureBtn = this.createButton(box, Messages.BUTTON_LABEL_CONFIGURE);
            return box;
        }

        private Button createButton(Composite box, String text) {
            Button button = new Button(box, 8);
            button.setText(text);
            button.setEnabled(false);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SessionProcessorEditor.this.openSessionProcessorPreferencePage(SessionProcessorEditor.this.tableViewer.getSelection());
                }
            });
            int widthHint = Math.max(this.convertHorizontalDLUsToPixels((Control)button, 61), button.computeSize((int)-1, (int)-1, (boolean)true).x);
            GridDataFactory.swtDefaults().align(4, 0x1000000).hint(widthHint, -1).applyTo((Control)button);
            return button;
        }

        private void updateButtonStatus() {
            int selectionIndex = this.tableViewer.getTable().getSelectionIndex();
            if (selectionIndex == -1) {
                this.configureBtn.setEnabled(false);
                return;
            }
            IStructuredSelection selected = (IStructuredSelection)this.tableViewer.getSelection();
            SessionProcessorDescriptor descriptor = (SessionProcessorDescriptor)Checks.cast((Object)selected.getFirstElement());
            this.configureBtn.setEnabled(descriptor.getPreferencePage().isPresent());
        }

        private void openSessionProcessorPreferencePage(ISelection selection) {
            Optional optionalDescriptor = Selections.getFirstSelected((ISelection)selection);
            if (!optionalDescriptor.isPresent()) {
                return;
            }
            SessionProcessorDescriptor descriptor = (SessionProcessorDescriptor)optionalDescriptor.get();
            if (!descriptor.getPreferencePage().isPresent()) {
                return;
            }
            String id = (String)descriptor.getPreferencePage().get();
            PreferencesUtil.createPreferenceDialogOn((Shell)CompletionsPreferencePage.this.getShell(), (String)id, null, null);
        }

        protected void doLoad() {
            Set<SessionProcessorDescriptor> input = CompletionsPreferencePage.this.preferences.getAvailableSessionProcessors();
            ArrayList checkedElements = Lists.newArrayList();
            for (SessionProcessorDescriptor descriptor : input) {
                if (!CompletionsPreferencePage.this.preferences.isEnabled(descriptor)) continue;
                checkedElements.add(descriptor);
            }
            this.tableViewer.setInput(input);
            this.tableViewer.setSorter(new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    SessionProcessorDescriptor lhs = (SessionProcessorDescriptor)Checks.cast((Object)e1);
                    SessionProcessorDescriptor rhs = (SessionProcessorDescriptor)Checks.cast((Object)e2);
                    return lhs.getName().compareTo(rhs.getName());
                }
            });
            this.tableViewer.setCheckedElements(checkedElements.toArray());
        }

        protected void doLoadDefault() {
            Set<SessionProcessorDescriptor> input = CompletionsPreferencePage.this.preferences.getAvailableSessionProcessors();
            ArrayList checkedElements = Lists.newArrayList();
            for (SessionProcessorDescriptor descriptor : input) {
                if (!descriptor.isEnabledByDefault()) continue;
                checkedElements.add(descriptor);
            }
            this.tableViewer.setInput(input);
            this.tableViewer.setCheckedElements(checkedElements.toArray());
            this.updateButtonStatus();
        }

        protected void doStore() {
            Set descriptors = (Set)Checks.cast((Object)this.tableViewer.getInput());
            CompletionsPreferencePage.this.preferences.setSessionProcessorEnabled(Collections2.filter((Collection)descriptors, (Predicate)new EnabledPredicate(true)), Collections2.filter((Collection)descriptors, (Predicate)new EnabledPredicate(false)));
            this.updateButtonStatus();
        }

        public int getNumberOfControls() {
            return 2;
        }

        private final class EnabledPredicate
        implements Predicate<SessionProcessorDescriptor> {
            private final boolean enabled;

            public EnabledPredicate(boolean enabled) {
                this.enabled = enabled;
            }

            public boolean apply(SessionProcessorDescriptor descriptor) {
                return !(this.enabled ^ SessionProcessorEditor.this.tableViewer.getChecked((Object)descriptor));
            }
        }
    }
}

