/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.recommenders.internal.snipmatch.rcp.AbstractSnippetRepositoryWizard;
import org.eclipse.recommenders.internal.snipmatch.rcp.BranchInputValidator;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.Messages;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.model.EclipseGitSnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.model.SnipmatchRcpModelFactory;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Urls;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class GitBasedRepositoryConfigurationWizard
extends AbstractSnippetRepositoryWizard {
    private static final List<String> ACCEPTED_PROTOCOLS = ImmutableList.of((Object)"file", (Object)"git", (Object)"http", (Object)"https", (Object)"ssh");
    private GitBasedRepositoryConfigurationWizardPage page = new GitBasedRepositoryConfigurationWizardPage(Messages.WIZARD_GIT_REPOSITORY_PAGE_NAME);
    private EclipseGitSnippetRepositoryConfiguration configuration;
    private final BranchInputValidator branchInputValidator = new BranchInputValidator();

    public GitBasedRepositoryConfigurationWizard() {
        this.setWindowTitle(Messages.WIZARD_GIT_REPOSITORY_WINDOW_TITLE);
        this.page.setWizard((IWizard)this);
        this.page.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.recommenders.snipmatch.rcp", (String)"icons/wizban/add_git_repository.png"));
    }

    public boolean performFinish() {
        this.configuration = SnipmatchRcpModelFactory.eINSTANCE.createEclipseGitSnippetRepositoryConfiguration();
        this.configuration.setName(this.page.txtName.getText());
        this.configuration.setUrl(this.page.txtFetchUri.getText());
        this.configuration.setPushUrl(this.page.txtPushUri.getText());
        this.configuration.setPushBranchPrefix(this.page.txtPushBranchPrefix.getText());
        return true;
    }

    @Override
    public SnippetRepositoryConfiguration getConfiguration() {
        return this.configuration;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public IWizardPage getStartingPage() {
        return this.page;
    }

    public boolean canFinish() {
        return this.page.canFinish();
    }

    @Override
    public boolean isApplicable(SnippetRepositoryConfiguration configuration) {
        return configuration instanceof EclipseGitSnippetRepositoryConfiguration;
    }

    @Override
    public void setConfiguration(SnippetRepositoryConfiguration configuration) {
        this.configuration = (EclipseGitSnippetRepositoryConfiguration)Checks.cast((Object)configuration);
        if (configuration != null) {
            this.page.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.recommenders.snipmatch.rcp", (String)"icons/wizban/edit_git_repository.png"));
            this.page.setDescription(Messages.WIZARD_GIT_REPOSITORY_EDIT_DESCRIPTION);
        }
    }

    class GitBasedRepositoryConfigurationWizardPage
    extends WizardPage {
        private Text txtName;
        private Text txtFetchUri;
        private Text txtPushUri;
        private Text txtPushBranchPrefix;

        protected GitBasedRepositoryConfigurationWizardPage(String pageName) {
            super(pageName);
            this.setTitle(Messages.WIZARD_GIT_REPOSITORY_TITLE);
            this.setDescription(Messages.WIZARD_GIT_REPOSITORY_ADD_DESCRIPTION);
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayoutFactory.swtDefaults().numColumns(3).applyTo(container);
            Label lblName = new Label(container, 0);
            lblName.setText(Messages.WIZARD_GIT_REPOSITORY_LABEL_NAME);
            this.txtName = new Text(container, 2052);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.txtName);
            this.txtName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GitBasedRepositoryConfigurationWizardPage.this.updatePageComplete();
                }
            });
            this.addFetchGroup(container);
            this.addPushGroup(container);
            if (GitBasedRepositoryConfigurationWizard.this.configuration != null) {
                this.txtName.setText(GitBasedRepositoryConfigurationWizard.this.configuration.getName());
                this.txtFetchUri.setText(GitBasedRepositoryConfigurationWizard.this.configuration.getUrl());
                this.txtPushUri.setText(GitBasedRepositoryConfigurationWizard.this.configuration.getPushUrl());
                this.txtPushBranchPrefix.setText(GitBasedRepositoryConfigurationWizard.this.configuration.getPushBranchPrefix());
            }
            this.txtName.forceFocus();
            this.setControl((Control)container);
            this.updatePageComplete();
        }

        private void addFetchGroup(Composite parent) {
            Group group = new Group(parent, 16);
            group.setText(Messages.WIZARD_GIT_REPOSITORY_GROUP_FETCH_SETTINGS);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)group);
            GridLayoutFactory.swtDefaults().margins(5, 5).numColumns(2).applyTo((Composite)group);
            Label lblFetchUri = new Label((Composite)group, 0);
            lblFetchUri.setText(Messages.WIZARD_GIT_REPOSITORY_LABEL_FETCH_URL);
            this.txtFetchUri = new Text((Composite)group, 2052);
            GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.txtFetchUri);
            this.txtFetchUri.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GitBasedRepositoryConfigurationWizardPage.this.updatePageComplete();
                }
            });
        }

        private void addPushGroup(Composite parent) {
            Group group = new Group(parent, 16);
            group.setText(Messages.WIZARD_GIT_REPOSITORY_GROUP_PUSH_SETTINGS);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)group);
            GridLayoutFactory.swtDefaults().margins(5, 5).numColumns(3).applyTo((Composite)group);
            Label lblPushUri = new Label((Composite)group, 0);
            lblPushUri.setText(Messages.WIZARD_GIT_REPOSITORY_LABEL_PUSH_URL);
            this.txtPushUri = new Text((Composite)group, 2052);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.txtPushUri);
            this.txtPushUri.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GitBasedRepositoryConfigurationWizardPage.this.updatePageComplete();
                }
            });
            Label lblPushSettingsDescription = new Label((Composite)group, 0);
            lblPushSettingsDescription.setText(MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_PUSH_SETTINGS_DESCRIPTION, "format-5"));
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)lblPushSettingsDescription);
            Label lblPushBranchPrefix = new Label((Composite)group, 0);
            lblPushBranchPrefix.setText(Messages.WIZARD_GIT_REPOSITORY_LABEL_PUSH_BRANCH_PREFIX);
            this.txtPushBranchPrefix = new Text((Composite)group, 2052);
            GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.txtPushBranchPrefix);
            this.txtPushBranchPrefix.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GitBasedRepositoryConfigurationWizardPage.this.updatePageComplete();
                }
            });
            Label lblBranch = new Label((Composite)group, 0);
            lblBranch.setText("/format-5");
        }

        public void updatePageComplete() {
            this.setErrorMessage(null);
            String pushBranchPrefixValid = GitBasedRepositoryConfigurationWizard.this.branchInputValidator.isValid(this.txtPushBranchPrefix.getText());
            URI fetchUri = (URI)Urls.parseURI((String)this.txtFetchUri.getText()).orNull();
            URI pushUri = (URI)Urls.parseURI((String)this.txtPushUri.getText()).orNull();
            if (Strings.isNullOrEmpty((String)this.txtName.getText())) {
                this.setErrorMessage(Messages.WIZARD_GIT_REPOSITORY_ERROR_EMPTY_NAME);
            } else if (Strings.isNullOrEmpty((String)this.txtFetchUri.getText())) {
                this.setErrorMessage(Messages.WIZARD_GIT_REPOSITORY_ERROR_EMPTY_FETCH_URL);
            } else if (fetchUri == null) {
                this.setErrorMessage(MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_ERROR_INVALID_URL, this.txtFetchUri.getText()));
            } else if (!fetchUri.isAbsolute()) {
                this.setErrorMessage(MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_ERROR_ABSOLUTE_URL_REQUIRED, this.txtFetchUri.getText()));
            } else if (!Urls.isUriProtocolSupported((URI)fetchUri, (List)ACCEPTED_PROTOCOLS)) {
                this.setErrorMessage(MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_ERROR_URL_PROTOCOL_UNSUPPORTED, this.txtFetchUri.getText(), StringUtils.join((Iterable)ACCEPTED_PROTOCOLS, (String)Messages.LIST_SEPARATOR)));
            } else if (Strings.isNullOrEmpty((String)this.txtPushUri.getText())) {
                this.setErrorMessage(Messages.WIZARD_GIT_REPOSITORY_ERROR_EMPTY_PUSH_URL);
            } else if (pushUri == null) {
                this.setErrorMessage(MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_ERROR_INVALID_URL, this.txtPushUri.getText()));
            } else if (!pushUri.isAbsolute()) {
                this.setErrorMessage(MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_ERROR_ABSOLUTE_URL_REQUIRED, this.txtPushUri.getText()));
            } else if (!Urls.isUriProtocolSupported((URI)pushUri, (List)ACCEPTED_PROTOCOLS)) {
                this.setErrorMessage(MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_ERROR_URL_PROTOCOL_UNSUPPORTED, this.txtPushUri.getText(), StringUtils.join((Iterable)ACCEPTED_PROTOCOLS, (String)Messages.LIST_SEPARATOR)));
            } else if (Strings.isNullOrEmpty((String)this.txtPushBranchPrefix.getText())) {
                this.setErrorMessage(Messages.WIZARD_GIT_REPOSITORY_ERROR_EMPTY_BRANCH_PREFIX);
            } else if (pushBranchPrefixValid != null) {
                this.setErrorMessage(pushBranchPrefixValid);
            }
            this.setPageComplete(this.getErrorMessage() == null);
        }

        public boolean canFinish() {
            return this.isPageComplete();
        }
    }
}

