/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.links;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.recommenders.internal.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.rcp.links.ContributionLink;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ContributionsReader {
    private static final String PREF_CONTRIBUTION_ID = "org.eclipse.recommenders.rcp.linkContribution";
    private static final String CONTRIBUTION_ELEMENT = "linkContribution";
    private static final String PREF_PAGE_ID_ATTRIBUTE = "preferencePageId";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String COMMAND_ID_ATTRIBUTE = "commandId";
    private static final String PRIORITY_ATTRIBUTE = "priority";
    private static final String ICON_ELEMENT = "icon";

    private ContributionsReader() {
    }

    public static List<ContributionLink> readContributionLinks(String preferencePageId) {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(PREF_CONTRIBUTION_ID);
        return ContributionsReader.readContributionLinks(preferencePageId, configurationElements);
    }

    @VisibleForTesting
    static List<ContributionLink> readContributionLinks(String preferencePageId, IConfigurationElement ... configurationElements) {
        ArrayList links = Lists.newArrayList();
        if (configurationElements == null) {
            return ImmutableList.of();
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (CONTRIBUTION_ELEMENT.equals(configurationElement.getName())) {
                String pluginId = configurationElement.getContributor().getName();
                String pageId = configurationElement.getAttribute(PREF_PAGE_ID_ATTRIBUTE);
                if (preferencePageId.equals(pageId)) {
                    String labelAttribute = configurationElement.getAttribute(LABEL_ATTRIBUTE);
                    String commandIdAttribute = configurationElement.getAttribute(COMMAND_ID_ATTRIBUTE);
                    String priorityAttribute = configurationElement.getAttribute(PRIORITY_ATTRIBUTE);
                    String iconAttribute = configurationElement.getAttribute(ICON_ELEMENT);
                    try {
                        Image image = null;
                        if (iconAttribute != null) {
                            image = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)iconAttribute).createImage();
                        }
                        if (ContributionsReader.isValidAttribute(labelAttribute) && ContributionsReader.isValidAttribute(commandIdAttribute)) {
                            int priority = priorityAttribute == null ? Integer.MAX_VALUE : Integer.parseInt(priorityAttribute);
                            links.add(new ContributionLink(labelAttribute, commandIdAttribute, priority, image));
                        } else {
                            Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_FAILED_TO_READ_EXTENSION_ELEMENT, (Object[])new Object[]{CONTRIBUTION_ELEMENT});
                        }
                    }
                    catch (Exception exception) {
                        Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_FAILED_TO_READ_EXTENSION_ELEMENT, (Object[])new Object[]{CONTRIBUTION_ELEMENT});
                    }
                }
            }
            ++n2;
        }
        Collections.sort(links);
        return ImmutableList.copyOf((Collection)links);
    }

    private static boolean isValidAttribute(String attribute) {
        return !Strings.isNullOrEmpty((String)attribute);
    }
}

