/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.recommenders.internal.snipmatch.rcp.AbstractSnippetRepositoryWizard;
import org.eclipse.recommenders.internal.snipmatch.rcp.WizardDescriptor;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.utils.Checks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WizardDescriptors {
    private static final Logger LOG = LoggerFactory.getLogger(WizardDescriptors.class);
    private static final String CONFIGURATION_WIZARD_NAME = "name";
    private static final String CONFIGURATION_WIZARD = "wizard";
    private static final String EXT_ID_CONFIGURATION_WIZARDS = "org.eclipse.recommenders.snipmatch.rcp.configurationwizards";

    private WizardDescriptors() {
    }

    public static List<WizardDescriptor> loadAvailableWizards() {
        ArrayList wizardDescriptors = Lists.newArrayList();
        try {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_ID_CONFIGURATION_WIZARDS);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                AbstractSnippetRepositoryWizard wizard = (AbstractSnippetRepositoryWizard)((Object)Checks.cast((Object)configurationElement.createExecutableExtension(CONFIGURATION_WIZARD)));
                String name = configurationElement.getAttribute(CONFIGURATION_WIZARD_NAME);
                wizardDescriptors.add(new WizardDescriptor(name, wizard));
                ++n2;
            }
        }
        catch (CoreException e) {
            LOG.error(MessageFormat.format("Exception while reading extension point {}", EXT_ID_CONFIGURATION_WIZARDS), (Throwable)e);
        }
        return wizardDescriptors;
    }

    public static List<WizardDescriptor> filterApplicableWizardDescriptors(List<WizardDescriptor> descriptors, SnippetRepositoryConfiguration config) {
        ArrayList wizardDescriptors = Lists.newArrayList();
        for (WizardDescriptor descriptor : descriptors) {
            if (!descriptor.getWizard().isApplicable(config)) continue;
            wizardDescriptors.add(descriptor);
        }
        return wizardDescriptors;
    }

    public static boolean isWizardAvailable(SnippetRepositoryConfiguration config) {
        return !WizardDescriptors.filterApplicableWizardDescriptors(WizardDescriptors.loadAvailableWizards(), config).isEmpty();
    }
}

