/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.types.rcp;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.recommenders.internal.types.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.types.rcp.l10n.Messages;
import org.eclipse.recommenders.jdt.JavaElementsFinder;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.Names;

public class ProjectTypesIndex
extends AbstractIdleService {
    private static final int TICKS = 80000;
    private static final String F_PACAKGE_FRAGEMENT_ROOT_TYPE = "pfrType";
    private static final String F_NAME = "name";
    private static final String F_SIMPLE_NAME = "simpleName";
    private static final String F_LAST_MODIFIED = "lastModified";
    private static final String F_LOCATION = "location";
    private static final String F_INSTANCEOF = "instanceof";
    private static final String V_JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String V_ARCHIVE = "archive";
    private IJavaProject project;
    private File indexDir;
    private Directory directory;
    private IndexWriter writer;
    private IndexReader reader;
    private IndexSearcher searcher;
    private JobFuture active = null;
    private boolean rebuildAfterNextAccess;

    public ProjectTypesIndex(IJavaProject project, File indexDir) {
        this.project = project;
        this.indexDir = indexDir;
    }

    protected void startUp() throws Exception {
        this.directory = FSDirectory.open((File)this.indexDir);
        if (IndexWriter.isLocked((Directory)this.directory)) {
            IndexWriter.unlock((Directory)this.directory);
        }
        IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)new KeywordAnalyzer());
        this.writer = new IndexWriter(this.directory, conf);
        this.writer.commit();
        if (this.needsRebuild()) {
            this.rebuild();
        }
    }

    public boolean needsRebuild() {
        StringBuilder sb = new StringBuilder();
        try {
            List<IPackageFragmentRoot> roots = this.findArchivePackageFragmentRoots();
            Map<File, Long> indexedRoots = this.getSavedState();
            for (IPackageFragmentRoot root : roots) {
                File location = (File)JavaElementsFinder.findLocation((IPackageFragmentRoot)root).orNull();
                if (indexedRoots.remove(location) == null) {
                    sb.append("  [+] ").append(location).append('\n');
                    continue;
                }
                if (this.isCurrent(root)) continue;
                sb.append("  [*] ").append(location).append('\n');
            }
            if (!indexedRoots.isEmpty()) {
                for (File file : indexedRoots.keySet()) {
                    sb.append("  [-] ").append(file.getAbsolutePath()).append('\n');
                }
            }
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
        if (sb.length() > 0) {
            Logs.log((Logs.ILogMessage)LogMessages.INFO_REINDEXING_REQUIRED, (Object[])new Object[]{sb.toString()});
            return true;
        }
        return false;
    }

    private List<IPackageFragmentRoot> findArchivePackageFragmentRoots() {
        Iterable filter = Iterables.filter((Iterable)JavaElementsFinder.findPackageFragmentRoots((IJavaProject)this.project), (Predicate)new ArchiveFragmentRootsOnlyPredicate());
        return Ordering.usingToString().sortedCopy(filter);
    }

    private Map<File, Long> getSavedState() throws IOException {
        HashMap res = Maps.newHashMap();
        IndexSearcher searcher = this.getSearcher();
        TopDocs topDocs = searcher.search((Query)new TermQuery(this.termPackageFragmentRootType()), Integer.MAX_VALUE);
        ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
        int n = topDocs.scoreDocs.length;
        int n2 = 0;
        while (n2 < n) {
            ScoreDoc scoreDoc = scoreDocArray[n2];
            Document doc = searcher.doc(scoreDoc.doc);
            File location = new File(doc.get(F_LOCATION));
            Long lastModified = Long.parseLong(doc.get(F_LAST_MODIFIED));
            res.put(location, lastModified);
            ++n2;
        }
        return res;
    }

    private Term termPackageFragmentRootType() {
        return new Term(F_PACAKGE_FRAGEMENT_ROOT_TYPE, V_ARCHIVE);
    }

    private boolean isIndexed(IPackageFragmentRoot root) throws IOException {
        File rootLocation = (File)JavaElementsFinder.findLocation((IPackageFragmentRoot)root).orNull();
        TermQuery query = new TermQuery(this.termLocation(rootLocation));
        IndexSearcher searcher = this.getSearcher();
        return searcher.search((Query)query, (int)1).totalHits > 0;
    }

    private boolean isCurrent(IPackageFragmentRoot root) throws IOException {
        File rootLocation = (File)JavaElementsFinder.findLocation((IPackageFragmentRoot)root).orNull();
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(this.termLocation(rootLocation)), BooleanClause.Occur.MUST);
        query.add((Query)NumericRangeQuery.newLongRange((String)F_LAST_MODIFIED, (Long)rootLocation.lastModified(), (Long)rootLocation.lastModified(), (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        IndexSearcher searcher = this.getSearcher();
        return searcher.search((Query)query, (int)1).totalHits > 0;
    }

    private Term termLocation(File rootLocation) {
        return new Term(F_LOCATION, rootLocation.getAbsolutePath());
    }

    public boolean isEmpty() {
        try {
            return this.writer.numDocs() == 0;
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
            return true;
        }
    }

    protected void shutDown() throws Exception {
        IOUtils.close((Closeable[])new Closeable[]{this.reader, this.writer, this.directory});
    }

    public ImmutableSet<String> subtypes(IType expected, String prefix) {
        if (expected == null) {
            return ImmutableSet.of();
        }
        return this.subtypes(expected.getFullyQualifiedName(), prefix);
    }

    public ImmutableSet<String> subtypes(ITypeName expected, String prefix) {
        try {
            return this.subtypes(Names.vm2srcQualifiedType((ITypeName)expected), prefix);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
            return ImmutableSet.of();
        }
    }

    public ImmutableSet<String> subtypes(String type, String prefix) {
        ImmutableSet.Builder b = ImmutableSet.builder();
        if (!this.isRunning() || StringUtils.isBlank((CharSequence)type)) {
            return b.build();
        }
        IndexSearcher searcher = this.getSearcher();
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term(F_INSTANCEOF, type)), BooleanClause.Occur.MUST);
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            query.add((Query)new WildcardQuery(new Term(F_SIMPLE_NAME, String.valueOf(prefix) + '*')), BooleanClause.Occur.MUST);
        }
        try {
            TopDocs search = searcher.search((Query)query, Integer.MAX_VALUE);
            ScoreDoc[] scoreDocArray = search.scoreDocs;
            int n = search.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc sdoc = scoreDocArray[n2];
                Document doc = searcher.doc(sdoc.doc);
                String name = doc.get(F_NAME);
                b.add((Object)name);
                ++n2;
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
        if (this.isRebuildAfterNextAccess()) {
            this.setRebuildAfterNextAccess(false);
            this.rebuild();
        }
        return b.build();
    }

    private IndexSearcher getSearcher() {
        if (this.reader == null) {
            this.reader = this.createReader();
            this.searcher = new IndexSearcher(this.reader);
            return this.searcher;
        }
        try {
            IndexReader newReader = IndexReader.openIfChanged((IndexReader)this.reader);
            if (newReader != null) {
                this.reader.close();
                this.reader = newReader;
                this.searcher = new IndexSearcher(this.reader);
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
        return this.searcher;
    }

    private IndexReader createReader() {
        try {
            return IndexReader.open((Directory)this.directory);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void clear() {
        try {
            this.writer.deleteAll();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
    }

    public ListenableFuture<IStatus> rebuild() {
        JobFuture res;
        if (this.active != null && !this.active.isDone() && !this.active.isCancelled()) {
            this.active.cancel(true);
        }
        this.active = res = new JobFuture();
        Job job = new Job(MessageFormat.format(Messages.JOB_NAME_INDEXING, this.project.getElementName())){

            protected IStatus run(IProgressMonitor monitor) {
                block7: {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)(String.valueOf(Messages.MONITOR_NAME_INDEXING) + ProjectTypesIndex.this.project.getElementName()), (int)80000);
                    Thread thread = Thread.currentThread();
                    int priority = thread.getPriority();
                    try {
                        thread.setPriority(1);
                        ProjectTypesIndex.this.clear();
                        ProjectTypesIndex.this.rebuild(progress);
                        ProjectTypesIndex.this.commit();
                    }
                    catch (OperationCanceledException e) {
                        res.setException(e);
                        res.setResult(Status.CANCEL_STATUS);
                        thread.setPriority(priority);
                        monitor.done();
                        break block7;
                    }
                    catch (Exception e) {
                        try {
                            res.setException(e);
                            res.setResult((IStatus)new Status(4, "org.eclipse.recommenders.types.rcp", e.getMessage(), (Throwable)e));
                            break block7;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            thread.setPriority(priority);
                            monitor.done();
                        }
                    }
                    thread.setPriority(priority);
                    monitor.done();
                }
                res.setResult(Status.OK_STATUS);
                return Status.OK_STATUS;
            }
        };
        res.setJob(job);
        job.schedule(2000L);
        return res;
    }

    private synchronized void rebuild(SubMonitor progress) {
        List<IPackageFragmentRoot> roots = this.findArchivePackageFragmentRoots();
        for (IPackageFragmentRoot root : roots) {
            progress.subTask(root.getElementName());
            ImmutableList types = JavaElementsFinder.findTypes((IPackageFragmentRoot)root);
            for (IType type : types) {
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.indexType(type);
                progress.worked(1);
            }
            File location = (File)JavaElementsFinder.findLocation((IPackageFragmentRoot)root).orNull();
            if (location != null) {
                this.registerArchivePackageFragmentRoot(location);
            }
            this.commit();
        }
        progress.done();
    }

    private void registerArchivePackageFragmentRoot(File location) {
        Document doc = new Document();
        doc.add((Fieldable)new Field(F_PACAKGE_FRAGEMENT_ROOT_TYPE, V_ARCHIVE, Field.Store.NO, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(F_LOCATION, location.getAbsolutePath(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new NumericField(F_LAST_MODIFIED, Field.Store.YES, true).setLongValue(location.lastModified()));
        try {
            this.writer.addDocument(doc);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
    }

    public void commit() {
        try {
            this.writer.commit();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
    }

    public void compact() {
        try {
            this.writer.forceMerge(1, true);
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
    }

    public void refresh(IType type) {
        ImmutableSet<String> subtypes = this.subtypes(type, "");
        this.removeSubtypes(type);
        this.indexType(type);
        for (String subtypeName : subtypes) {
            IType subtype = (IType)JavaElementsFinder.findType((String)subtypeName, (IJavaProject)this.getProject()).orNull();
            if (subtype == null) continue;
            this.indexType(subtype);
        }
    }

    private void removeSubtypes(IType type) {
        File location = (File)this.findPackageFragmentRoot(type).orNull();
        if (location == null) {
            return;
        }
        TermQuery query = new TermQuery(new Term(F_INSTANCEOF, type.getFullyQualifiedName()));
        try {
            this.writer.deleteDocuments((Query)query);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
    }

    public void removeType(IType type) throws CorruptIndexException, IOException {
        File location = (File)this.findPackageFragmentRoot(type).orNull();
        if (location == null) {
            return;
        }
        BooleanQuery delete = new BooleanQuery();
        delete.add((Query)new TermQuery(this.termLocation(location)), BooleanClause.Occur.MUST);
        delete.add((Query)new TermQuery(new Term(F_NAME, type.getFullyQualifiedName())), BooleanClause.Occur.MUST);
        this.writer.deleteDocuments((Query)delete);
    }

    public void removePackageFragment(IPackageFragment fragment) throws CorruptIndexException, IOException {
        File location = (File)this.findPackageFragmentRootLocation(fragment).orNull();
        if (location == null) {
            return;
        }
        BooleanQuery delete = new BooleanQuery();
        delete.add((Query)new TermQuery(this.termLocation(location)), BooleanClause.Occur.MUST);
        delete.add((Query)new TermQuery(new Term(F_NAME, String.valueOf(fragment.getElementName()) + "*")), BooleanClause.Occur.MUST);
        this.writer.deleteDocuments((Query)delete);
    }

    public void removePackageFragmentRoot(IPackageFragmentRoot root) throws CorruptIndexException, IOException {
        File location = (File)JavaElementsFinder.findLocation((IPackageFragmentRoot)root).orNull();
        if (location == null) {
            return;
        }
        TermQuery delete = new TermQuery(this.termLocation(location));
        this.writer.deleteDocuments((Query)delete);
    }

    public void indexType(IType type) {
        Document doc = new Document();
        doc.add((Fieldable)new Field(F_NAME, type.getFullyQualifiedName(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(F_SIMPLE_NAME, type.getElementName(), Field.Store.NO, Field.Index.NOT_ANALYZED));
        File location = (File)this.findPackageFragmentRoot(type).orNull();
        if (location != null) {
            doc.add((Fieldable)new Field(F_LOCATION, location.getAbsolutePath(), Field.Store.NO, Field.Index.NOT_ANALYZED));
        }
        doc.add((Fieldable)new Field(F_INSTANCEOF, type.getFullyQualifiedName(), Field.Store.NO, Field.Index.NOT_ANALYZED));
        try {
            ITypeHierarchy h = type.newSupertypeHierarchy(null);
            IType[] iTypeArray = h.getAllSupertypes(type);
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType supertypes = iTypeArray[n2];
                String fullyQualifiedName = supertypes.getFullyQualifiedName();
                if (!Objects.equal((Object)V_JAVA_LANG_OBJECT, (Object)fullyQualifiedName)) {
                    doc.add((Fieldable)new Field(F_INSTANCEOF, fullyQualifiedName, Field.Store.NO, Field.Index.NOT_ANALYZED));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
        this.addDocument(doc);
    }

    private void addDocument(Document doc) {
        try {
            this.writer.addDocument(doc);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
    }

    private Optional<File> findPackageFragmentRoot(IType type) {
        IPackageFragmentRoot ancestor = (IPackageFragmentRoot)type.getAncestor(3);
        return JavaElementsFinder.findLocation((IPackageFragmentRoot)ancestor);
    }

    private Optional<File> findPackageFragmentRootLocation(IPackageFragment fragment) {
        IPackageFragmentRoot ancestor = (IPackageFragmentRoot)fragment.getAncestor(3);
        return JavaElementsFinder.findLocation((IPackageFragmentRoot)ancestor);
    }

    public void indexTypeRoot(ITypeRoot root) {
        if (root instanceof ICompilationUnit) {
            this.indexCompilationUnit((ICompilationUnit)root);
        } else if (root instanceof IClassFile) {
            this.indexClassFile((IClassFile)root);
        }
    }

    public void indexCompilationUnit(ICompilationUnit cu) {
        try {
            IType[] iTypeArray = cu.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                this.indexType(type);
                ++n2;
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
    }

    public void indexClassFile(IClassFile root) {
        this.indexType(root.getType());
    }

    public void removeCompilationUnit(ICompilationUnit cu) {
        try {
            IType[] iTypeArray = cu.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                this.removeType(type);
                ++n2;
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
    }

    public IJavaProject getProject() {
        return this.project;
    }

    public void setRebuildAfterNextAccess(boolean value) {
        this.rebuildAfterNextAccess = value;
    }

    public boolean isRebuildAfterNextAccess() {
        return this.rebuildAfterNextAccess;
    }

    private static final class ArchiveFragmentRootsOnlyPredicate
    implements Predicate<IPackageFragmentRoot> {
        private ArchiveFragmentRootsOnlyPredicate() {
        }

        public boolean apply(IPackageFragmentRoot input) {
            if (input == null) {
                return false;
            }
            if (!input.isArchive()) {
                return false;
            }
            File location = (File)JavaElementsFinder.findLocation((IPackageFragmentRoot)input).orNull();
            return location != null;
        }
    }

    private static final class JobFuture
    extends AbstractFuture<IStatus> {
        private Job job;

        private JobFuture() {
        }

        public void setJob(Job job) {
            this.job = job;
        }

        public boolean setResult(IStatus value) {
            return super.set((Object)value);
        }

        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.job != null) {
                return this.job.cancel();
            }
            return false;
        }
    }
}

