/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.types.rcp;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessorDescriptor;
import org.eclipse.recommenders.completion.rcp.tips.AbstractCompletionTipProposal;
import org.eclipse.recommenders.completion.rcp.tips.ConfigureContentAssistInformationControl;
import org.eclipse.recommenders.internal.completion.rcp.CompletionRcpPreferences;
import org.eclipse.recommenders.internal.types.rcp.l10n.Messages;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class EnableTypesCompletionProposal
extends AbstractCompletionTipProposal {
    private static final List<SessionProcessorDescriptor> NONE = Collections.emptyList();
    private static final String URL_ABOUT_ENABLE = "X-sessionProcessor:+org.eclipse.recommenders.types.rcp.sessionprocessors.types";
    private static final String URL_HTTP_MANUAL = "https://www.eclipse.org/recommenders/manual/#completion-engines";
    private static final String INFO = MessageFormat.format(Messages.PROPOSAL_TOOLTIP_ENABLE_TYPES_COMPLETION, "X-sessionProcessor:+org.eclipse.recommenders.types.rcp.sessionprocessors.types", "https://www.eclipse.org/recommenders/manual/#completion-engines");
    private static final int ENABLE_TYPE_COMPLETION_RELEVANCE = 2147463647;
    private final CompletionRcpPreferences preferences;

    @Inject
    public EnableTypesCompletionProposal(SharedImages images, CompletionRcpPreferences completionPreferences) {
        this.preferences = completionPreferences;
        Image image = images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_LIGHTBULB);
        this.setRelevance(2147463647);
        this.setImage(image);
        StyledString text = new StyledString(Messages.PROPOSAL_LABEL_ENABLE_TYPES_COMPLETION, StyledString.DECORATIONS_STYLER);
        this.setStyledDisplayString(text);
        this.setSortString(text.getString());
    }

    public boolean isApplicable(IRecommendersCompletionContext context) {
        SessionProcessorDescriptor descriptor = this.preferences.getSessionProcessorDescriptor("org.eclipse.recommenders.types.rcp.sessionprocessors.types");
        if (descriptor == null) {
            return false;
        }
        if (this.preferences.isEnabled(descriptor)) {
            return false;
        }
        Set expectedTypes = context.getExpectedTypeNames();
        return !expectedTypes.isEmpty();
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        SessionProcessorDescriptor descriptor = this.preferences.getSessionProcessorDescriptor("org.eclipse.recommenders.types.rcp.sessionprocessors.types");
        if (descriptor != null) {
            this.preferences.setSessionProcessorEnabled((Collection)ImmutableList.of((Object)descriptor), NONE);
        }
    }

    protected IInformationControl createInformationControl(Shell parent, String statusLineText) {
        return new ConfigureContentAssistInformationControl(parent, statusLineText, INFO, this.preferences);
    }
}

