/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.calls.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMessageSend;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedNameReference;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.recommenders.calls.ICallModel;
import org.eclipse.recommenders.calls.ICallModelProvider;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.IProposalNameProvider;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.OverlayImageProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.completion.rcp.processable.SimpleProposalProcessor;
import org.eclipse.recommenders.internal.calls.rcp.CallCompletionContextFunctions;
import org.eclipse.recommenders.internal.calls.rcp.CallsRcpPreferences;
import org.eclipse.recommenders.internal.calls.rcp.ProposalMatcher;
import org.eclipse.recommenders.internal.calls.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.models.rcp.PrefetchModelArchiveJob;
import org.eclipse.recommenders.models.IModelProvider;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.utils.Constants;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Recommendations;
import org.eclipse.recommenders.utils.Result;
import org.eclipse.recommenders.utils.names.IMethodName;

public class CallCompletionSessionProcessor
extends SessionProcessor {
    private static final CompletionProposal NULL_PROPOSAL = new CompletionProposal();
    private final ImmutableSet<Class<? extends ASTNode>> supportedCompletionRequests = ImmutableSet.of(CompletionOnMemberAccess.class, CompletionOnMessageSend.class, CompletionOnQualifiedNameReference.class, CompletionOnSingleNameReference.class);
    private final IProjectCoordinateProvider pcProvider;
    private final ICallModelProvider modelProvider;
    private final IProposalNameProvider methodNameProvider;
    private final CallsRcpPreferences prefs;
    private final OverlayImageProposalProcessor overlayProcessor;
    private IRecommendersCompletionContext ctx;
    private Iterable<Recommendation<IMethodName>> recommendations;
    private ICallModel model;
    private Set<IMethodName> observedCalls;
    private Map<Recommendation<IMethodName>, Integer> recommendationsIndex;

    @Inject
    public CallCompletionSessionProcessor(IProjectCoordinateProvider pcProvider, ICallModelProvider modelProvider, IProposalNameProvider methodNameProvider, CallsRcpPreferences prefs, SharedImages images) {
        this.pcProvider = pcProvider;
        this.modelProvider = modelProvider;
        this.methodNameProvider = methodNameProvider;
        this.prefs = prefs;
        this.overlayProcessor = new OverlayImageProposalProcessor(images.getDescriptor((SharedImages.ImageResource)SharedImages.Images.OVR_STAR), 0);
    }

    public boolean startSession(IRecommendersCompletionContext context) {
        this.ctx = context;
        this.recommendations = Lists.newLinkedList();
        try {
            boolean bl = this.isCompletionRequestSupported() && this.findReceiverTypeAndModel() && this.findRecommendations();
            return bl;
        }
        finally {
            this.releaseModel();
        }
    }

    private boolean isCompletionRequestSupported() {
        ASTNode node = (ASTNode)this.ctx.getCompletionNode().orNull();
        if (node == null) {
            return false;
        }
        for (Class supportedCompletionRequest : this.supportedCompletionRequests) {
            if (!supportedCompletionRequest.isInstance(node)) continue;
            return true;
        }
        return false;
    }

    private boolean findReceiverTypeAndModel() {
        IType receiverType = (IType)this.ctx.get(CallCompletionContextFunctions.RECEIVER_TYPE2, null);
        if (receiverType == null) {
            return false;
        }
        Result res = this.pcProvider.tryToUniqueName(receiverType);
        switch (res.getReason()) {
            case 0: {
                this.model = (ICallModel)this.modelProvider.acquireModel((IUniqueName)((UniqueTypeName)res.get())).orNull();
                return this.model != null;
            }
            case 1: {
                new PrefetchModelArchiveJob(receiverType, this.pcProvider, (IModelProvider)this.modelProvider).schedule(200L);
            }
        }
        return false;
    }

    private boolean findRecommendations() {
        IMethod overrides = (IMethod)this.ctx.get(CompletionContextKey.ENCLOSING_METHOD_FIRST_DECLARATION, null);
        if (overrides != null) {
            IMethodName crOverrides = (IMethodName)this.pcProvider.toName(overrides).or((Object)Constants.UNKNOWN_METHOD);
            this.model.setObservedOverrideContext(crOverrides);
        }
        this.model.setObservedDefinitionKind((ICallModel.DefinitionKind)this.ctx.get(CallCompletionContextFunctions.RECEIVER_DEF_TYPE, null));
        this.model.setObservedDefiningMethod((IMethodName)this.ctx.get(CallCompletionContextFunctions.RECEIVER_DEF_BY, null));
        this.observedCalls = Sets.newHashSet((Iterable)((Iterable)this.ctx.get(CallCompletionContextFunctions.RECEIVER_CALLS, Collections.emptyList())));
        this.model.setObservedCalls(this.observedCalls);
        this.recommendations = this.model.recommendCalls();
        if (this.ctx.getExpectedTypeSignature().isPresent()) {
            this.recommendations = Recommendations.filterVoid(this.recommendations);
        }
        this.recommendations = Recommendations.top(this.recommendations, (int)this.prefs.maxNumberOfProposals, (double)(Math.max((double)this.prefs.minProposalProbability, 0.01) / 100.0));
        this.calculateProposalRelevanceBoostMap();
        return !Iterables.isEmpty(this.recommendations) || !this.observedCalls.isEmpty();
    }

    private void calculateProposalRelevanceBoostMap() {
        this.recommendationsIndex = Maps.newHashMap();
        for (Recommendation<IMethodName> r : this.recommendations) {
            int promille;
            double rel = r.getRelevance() * 100.0;
            int score = 0;
            score = rel < 1.0 ? (promille = DoubleMath.roundToInt((double)(rel * 100.0), (RoundingMode)RoundingMode.HALF_EVEN)) : 100 + DoubleMath.roundToInt((double)rel, (RoundingMode)RoundingMode.HALF_EVEN);
            this.recommendationsIndex.put(r, score);
        }
    }

    private void releaseModel() {
        if (this.model != null) {
            this.modelProvider.releaseModel((Object)this.model);
        }
    }

    public void process(IProcessableProposal proposal) {
        CompletionProposal coreProposal = (CompletionProposal)proposal.getCoreProposal().or((Object)NULL_PROPOSAL);
        switch (coreProposal.getKind()) {
            case 6: 
            case 12: 
            case 24: {
                IMethodName proposedMethod = (IMethodName)this.methodNameProvider.toMethodName(coreProposal).orNull();
                if (proposedMethod == null) {
                    return;
                }
                ProposalMatcher matcher = new ProposalMatcher(proposedMethod);
                if (this.prefs.highlightUsedProposals && this.handleAlreadyUsedProposal(proposal, matcher)) {
                    return;
                }
                this.handleRecommendation(proposal, matcher);
            }
        }
    }

    private boolean handleAlreadyUsedProposal(IProcessableProposal proposal, ProposalMatcher matcher) {
        for (IMethodName observed : this.observedCalls) {
            if (!matcher.match(observed)) continue;
            int boost = this.prefs.changeProposalRelevance ? 1 : 0;
            String label = this.prefs.decorateProposalText ? Messages.PROPOSAL_LABEL_USED : "";
            ProposalProcessorManager manager = proposal.getProposalProcessorManager();
            manager.addProcessor((ProposalProcessor)new SimpleProposalProcessor(boost, label));
            if (this.prefs.decorateProposalIcon) {
                manager.addProcessor((ProposalProcessor)this.overlayProcessor);
            }
            return true;
        }
        return false;
    }

    private void handleRecommendation(IProcessableProposal proposal, ProposalMatcher matcher) {
        for (Recommendation<IMethodName> call : this.recommendations) {
            int boost;
            IMethodName crMethod = (IMethodName)call.getProposal();
            if (!matcher.match(crMethod)) continue;
            Integer score = this.recommendationsIndex.get(call);
            int n = boost = this.prefs.changeProposalRelevance ? 200 + score : 0;
            if (boost > 0) {
                proposal.setTag((IProposalTag)ProposalTag.RECOMMENDERS_SCORE, (Object)score);
            }
            String label = "";
            if (this.prefs.decorateProposalText) {
                double relevance = call.getRelevance();
                String format = relevance < 0.01 ? Messages.PROPOSAL_LABEL_PROMILLE : Messages.PROPOSAL_LABEL_PERCENTAGE;
                label = MessageFormat.format(format, relevance);
            }
            ProposalProcessorManager mgr = proposal.getProposalProcessorManager();
            mgr.addProcessor((ProposalProcessor)new SimpleProposalProcessor(boost, label));
            if (this.prefs.decorateProposalIcon) {
                mgr.addProcessor((ProposalProcessor)this.overlayProcessor);
            }
            return;
        }
    }

    @VisibleForTesting
    public ICallModel getModel() {
        return this.model;
    }
}

