/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.subwords.rcp;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessorDescriptor;
import org.eclipse.recommenders.completion.rcp.tips.AbstractCompletionTipProposal;
import org.eclipse.recommenders.completion.rcp.tips.ConfigureContentAssistInformationControl;
import org.eclipse.recommenders.internal.completion.rcp.CompletionRcpPreferences;
import org.eclipse.recommenders.internal.subwords.rcp.l10n.Messages;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.rcp.utils.PreferencesHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class SubwordsCompletionWelcomeProposal
extends AbstractCompletionTipProposal {
    private static final List<SessionProcessorDescriptor> NONE = Collections.emptyList();
    private static final String URL_ABOUT_PREFERENCES = "X-preferences:org.eclipse.recommenders.subwords.rcp.preferencePages.subwords";
    private static final String URL_ABOUT_DISABLE = "X-sessionProcessor:-org.eclipse.recommenders.subwords.rcp.sessionprocessors.subwords";
    private static final String URL_HTTP_MANUAL = "https://www.eclipse.org/recommenders/manual/#completion-engines";
    private static final int RELEVANCE = 2147463647;
    private final CompletionRcpPreferences preferences;

    @Inject
    public SubwordsCompletionWelcomeProposal(SharedImages images, CompletionRcpPreferences completionPreferences) {
        this.preferences = completionPreferences;
        Image image = images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_LIGHTBULB);
        this.setImage(image);
        this.setRelevance(2147463647);
        StyledString text = new StyledString(Messages.PROPOSAL_LABEL_SUBWORDS_COMPLETION_WELCOME, StyledString.DECORATIONS_STYLER);
        this.setStyledDisplayString(text);
        this.setSortString(text.getString());
    }

    public boolean isApplicable(IRecommendersCompletionContext context) {
        SessionProcessorDescriptor descriptor = this.preferences.getSessionProcessorDescriptor("org.eclipse.recommenders.subwords.rcp.sessionprocessors.subwords");
        if (descriptor == null) {
            return false;
        }
        if (!this.preferences.isEnabled(descriptor)) {
            return false;
        }
        return !context.getPrefix().isEmpty();
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
    }

    protected IInformationControl createInformationControl(Shell parent, String statusLineText) {
        String info = MessageFormat.format(Messages.PROPOSAL_TOOLTIP_SUBWORDS_COMPLETION_WELCOME, PreferencesHelper.createLinkLabelToPreferencePage((String)"org.eclipse.recommenders.subwords.rcp.preferencePages.subwords"), URL_ABOUT_PREFERENCES, URL_ABOUT_DISABLE, URL_HTTP_MANUAL);
        return new ConfigureContentAssistInformationControl(parent, statusLineText, info, this.preferences);
    }
}

