/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.recommenders.utils.Throws;

public final class Checks {
    public static boolean anyIsNull(Object ... values) {
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            if (v == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void ensureEquals(Object value, Object expected, String message) {
        boolean equals;
        boolean bl = value == null ? expected == null : (equals = value.equals(expected));
        if (!equals) {
            String formattedMessage = String.format("Expected %s but got %s -- %s ", expected, value, message);
            Throws.throwIllegalArgumentException(formattedMessage);
        }
    }

    public static void ensureEquals(Object value, Object expected, String message, Object ... args) {
        boolean equals;
        boolean bl = value == null ? expected == null : (equals = value.equals(expected));
        if (!equals) {
            String error = String.format(message, args);
            String formattedMessage = String.format("Expected %s but got %s -- %s ", expected, value, error);
            Throws.throwIllegalArgumentException(formattedMessage);
        }
    }

    public static void ensureSame(int actual, int expected, String message, Object ... args) {
        if (actual != expected) {
            String formattedMessage = String.format("Expected %s but got %s -- %s ", expected, actual, message);
            Throws.throwIllegalArgumentException(formattedMessage);
        }
    }

    public static <T> T cast(Object object) {
        return (T)object;
    }

    public static File ensureExists(File file) {
        Checks.ensureIsNotNull(file);
        if (!file.exists()) {
            Throws.throwIllegalArgumentException("file %s does not exist.", file.getAbsolutePath());
        }
        return file;
    }

    public static File ensureIsDirectory(File directory) {
        Checks.ensureIsNotNull(directory);
        if (!directory.isDirectory()) {
            Throws.throwIllegalArgumentException("file %s is not a directory.", directory.getAbsolutePath());
        }
        return directory;
    }

    public static <T extends Collection<?>> T ensureIsEmpty(T collection) {
        if (!collection.isEmpty()) {
            Throws.throwIllegalArgumentException("collection is not empty!");
        }
        return collection;
    }

    public static File ensureIsFile(File file) {
        Checks.ensureIsNotNull(file);
        if (file.isDirectory()) {
            Throws.throwIllegalArgumentException("file %s is a directory.", file.getAbsolutePath());
        }
        return file;
    }

    public static void ensureIsFalse(boolean expression, String message, Object ... args) {
        if (expression) {
            Throws.throwIllegalArgumentException(message, args);
        }
    }

    public static void ensureIsGreaterOrEqualTo(double value, double min, String message) {
        if (value < min) {
            Throws.throwIllegalArgumentException("value '%f' is smaller than '%f': %s", value, min, message);
        }
    }

    public static void ensureIsGreaterOrEqualTo(double value, double min, String message, Object ... args) {
        if (value < min) {
            Throws.throwIllegalArgumentException(message, args);
        }
    }

    public static double ensureIsProbability(double value) {
        return Checks.ensureIsInRange(value, 0.0, 1.0, "value not in range [0,1]: %3.3f", value);
    }

    public static double ensureIsInRange(double value, double min, double max, String message, Object ... args) {
        boolean isInRange;
        boolean bl = isInRange = value >= min && value <= max;
        if (!isInRange) {
            Throws.throwIllegalArgumentException(message, args);
        }
        return value;
    }

    public static <T> T ensureIsInstanceOf(Object obj, Class<T> clazz) {
        Checks.ensureIsNotNull(clazz);
        Checks.ensureIsNotNull(obj, "null is not an instance of type '%s'", clazz.getName());
        boolean instanceOf = clazz.isInstance(obj);
        if (!instanceOf) {
            Throws.throwIllegalArgumentException("object of type '%s' is not a (sub-)type of '%s'", obj.getClass().getName(), clazz.getName());
        }
        return (T)obj;
    }

    public static <T extends Iterable<?>> T ensureIsNotEmpty(T iterable, String message, Object ... args) {
        Checks.ensureIsNotNull(iterable);
        Iterator<?> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            Throws.throwIllegalArgumentException(message, args);
        }
        return iterable;
    }

    public static String ensureIsNotEmpty(String testValue, String message, Object ... args) {
        Checks.ensureIsNotNull(testValue);
        if (testValue.length() == 0) {
            Throws.throwIllegalArgumentException(message, args);
        }
        return testValue;
    }

    public static void ensureIsNotInstanceOf(Object type, Class<?> expectedType) {
        Checks.ensureIsNotNull(expectedType);
        boolean isInstanceOf = expectedType.isInstance(type);
        if (isInstanceOf) {
            Throws.throwIllegalArgumentException("Wrong type - %s is instanceof %s but not allowed", type, expectedType);
        }
    }

    public static <T> T ensureIsNotNull(T arg) {
        return Checks.ensureIsNotNull(arg, "???", new Object[0]);
    }

    public static <T> T ensureIsNotNull(T arg, String message, Object ... args) {
        if (arg == null) {
            Throws.throwIllegalArgumentException(message, args);
        }
        return arg;
    }

    public static int ensureIsNotZero(int value) {
        if (value == 0) {
            Throws.throwIllegalArgumentException("Value of '0' is not allowed");
        }
        return value;
    }

    public static void ensureIsNull(Object arg) {
        Checks.ensureIsNull(arg, "Expected object to be null but got:%s", arg);
    }

    public static void ensureIsNull(Object arg, String message, Object ... args) {
        if (arg != null) {
            Throws.throwIllegalArgumentException(message, args);
        }
    }

    public static void ensureIsSorted(double[] values) {
        int i = values.length;
        while (i-- > 1) {
            if (!(values[i] > values[i - 1])) continue;
            throw new IllegalArgumentException("values are not sorted");
        }
    }

    public static void ensureNoDuplicates(String[] values) {
        HashSet set = Sets.newHashSet((Object[])values);
        if (values.length != set.size()) {
            Throws.throwIllegalArgumentException("Value contain duplicates");
        }
    }

    public static void ensureIsTrue(boolean exp) {
        Checks.ensureIsTrue(exp, "assertion failed.", new Object[0]);
    }

    public static void ensureIsTrue(boolean exp, String message, Object ... args) {
        if (!exp) {
            Throws.throwIllegalArgumentException(message, args);
        }
    }

    private Checks() {
    }

    public static <T, S extends T> S castOrNull(T object) {
        try {
            return (S)object;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

