/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.java.AnonymousTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.AnonymousTypeProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.Proposals;
import org.eclipse.recommenders.internal.completion.rcp.l10n.LogMessages;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Reflections;
import org.eclipse.swt.graphics.Image;

public class ProcessableAnonymousTypeCompletionProposal
extends AnonymousTypeCompletionProposal
implements IProcessableProposal {
    private static final Field F_SUPER_TYPE = (Field)Reflections.getDeclaredField(AnonymousTypeCompletionProposal.class, (String)"fSuperType").orNull();
    private Map<IProposalTag, Object> tags = Maps.newHashMap();
    private ProposalProcessorManager mgr;
    private CompletionProposal coreProposal;
    private String lastPrefix;
    private String lastPrefixStyled;
    private StyledString initialDisplayString;
    private Image decoratedImage;

    public ProcessableAnonymousTypeCompletionProposal(CompletionProposal coreProposal, AnonymousTypeCompletionProposal uiProposal, JavaContentAssistInvocationContext context) throws JavaModelException {
        super(context.getProject(), context.getCompilationUnit(), context, coreProposal.getReplaceStart(), uiProposal.getReplacementLength(), String.valueOf(coreProposal.getCompletion()), uiProposal.getStyledDisplayString(), String.valueOf(coreProposal.getDeclarationSignature()), ProcessableAnonymousTypeCompletionProposal.findSupertype(uiProposal, coreProposal, context), uiProposal.getRelevance());
        this.coreProposal = coreProposal;
    }

    private static IType findSupertype(AnonymousTypeCompletionProposal uiProposal, CompletionProposal coreProposal, JavaContentAssistInvocationContext context) throws JavaModelException {
        if (F_SUPER_TYPE != null) {
            try {
                IType superType = (IType)F_SUPER_TYPE.get(uiProposal);
                if (superType != null) {
                    return superType;
                }
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_EXCEPTION_DURING_CODE_COMPLETION, (Throwable)e);
            }
        }
        return (IType)context.getProject().findElement(String.valueOf(coreProposal.getDeclarationKey()), null);
    }

    protected ProposalInfo getProposalInfo() {
        ProposalInfo info = super.getProposalInfo();
        if (info == null) {
            IJavaProject project = this.fInvocationContext.getProject();
            info = new AnonymousTypeProposalInfo(project, this.coreProposal);
            this.setProposalInfo(info);
        }
        return info;
    }

    public Image getImage() {
        if (this.decoratedImage == null) {
            this.decoratedImage = this.mgr.decorateImage(super.getImage());
        }
        return this.decoratedImage;
    }

    @Override
    public StyledString getStyledDisplayString() {
        StyledString decorated;
        StyledString copy;
        if (this.initialDisplayString == null) {
            this.initialDisplayString = super.getStyledDisplayString();
            copy = Proposals.copyStyledString(this.initialDisplayString);
            decorated = this.mgr.decorateStyledDisplayString(copy);
            this.setStyledDisplayString(decorated);
        }
        if (this.lastPrefixStyled != this.lastPrefix) {
            this.lastPrefixStyled = this.lastPrefix;
            copy = Proposals.copyStyledString(this.initialDisplayString);
            decorated = this.mgr.decorateStyledDisplayString(copy);
            this.setStyledDisplayString(decorated);
        }
        return super.getStyledDisplayString();
    }

    public boolean isPrefix(String prefix, String completion) {
        this.lastPrefix = prefix;
        boolean res = this.mgr.prefixChanged(prefix) || super.isPrefix(prefix, completion);
        this.setTag(ProposalTag.IS_VISIBLE, res);
        return res;
    }

    @Override
    public String getPrefix() {
        return this.lastPrefix;
    }

    @Override
    public Optional<CompletionProposal> getCoreProposal() {
        return Optional.fromNullable((Object)this.coreProposal);
    }

    @Override
    public ProposalProcessorManager getProposalProcessorManager() {
        return this.mgr;
    }

    @Override
    public void setProposalProcessorManager(ProposalProcessorManager mgr) {
        this.mgr = mgr;
    }

    @Override
    public void setTag(IProposalTag key, Object value) {
        Checks.ensureIsNotNull((Object)key);
        if (value == null) {
            this.tags.remove(key);
        } else {
            this.tags.put(key, value);
        }
    }

    @Override
    public <T> Optional<T> getTag(IProposalTag key) {
        return Optional.fromNullable((Object)this.tags.get(key));
    }

    @Override
    public <T> Optional<T> getTag(String key) {
        return Proposals.getTag((ICompletionProposal)this, key);
    }

    @Override
    public <T> T getTag(IProposalTag key, T defaultValue) {
        Object res = this.tags.get(key);
        return (T)(res != null ? res : defaultValue);
    }

    @Override
    public <T> T getTag(String key, T defaultValue) {
        return (T)this.getTag(key).or(defaultValue);
    }

    @Override
    public ImmutableSet<IProposalTag> tags() {
        return ImmutableSet.copyOf(this.tags.keySet());
    }
}

