/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp.utils;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public final class Selections {
    private Selections() {
    }

    public static <T> Optional<T> getFirstSelected(OpenEvent e) {
        ISelection selection = e.getViewer().getSelection();
        return Selections.getFirstSelected(selection);
    }

    public static <T> Optional<T> getFirstSelected(Viewer viewer) {
        ISelection selection = viewer.getSelection();
        return Selections.getFirstSelected(selection);
    }

    public static IStructuredSelection asStructuredSelection(ISelection selection) {
        return (IStructuredSelection)(Selections.isStructured(selection) ? selection : StructuredSelection.EMPTY);
    }

    public static boolean isStructured(ISelection selection) {
        return selection instanceof IStructuredSelection;
    }

    public static <T> List<T> toList(ISelection selection) {
        return Selections.asStructuredSelection(selection).toList();
    }

    public static <T> Optional<T> safeFirstElement(ISelection s, Class<T> type) {
        Object element = Selections.asStructuredSelection(s).getFirstElement();
        return type.isInstance(element) ? Optional.of((Object)element) : Optional.absent();
    }

    public static <T> Optional<T> getFirstSelected(ISelection s) {
        T element = Selections.unsafeFirstElement(s);
        return Optional.fromNullable(element);
    }

    public static <T> T unsafeFirstElement(ISelection s) {
        return (T)Selections.asStructuredSelection(s).getFirstElement();
    }

    public static <T> Set<T> toSet(ISelection selection) {
        List<T> list = Selections.toList(selection);
        return Sets.newHashSet(list);
    }
}

