/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.constructors.rcp;

import com.google.common.base.Optional;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.recommenders.constructors.ConstructorModel;
import org.eclipse.recommenders.constructors.ConstructorModelProvider;
import org.eclipse.recommenders.constructors.IConstructorModelProvider;
import org.eclipse.recommenders.models.IInputStreamTransformer;
import org.eclipse.recommenders.models.IModelArchiveCoordinateAdvisor;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.rcp.IRcpService;

public class EclipseConstructorModelProvider
implements IConstructorModelProvider,
IRcpService {
    private final IModelRepository repository;
    private final IModelArchiveCoordinateAdvisor index;
    private final Map<String, IInputStreamTransformer> transformers;
    private IConstructorModelProvider delegate;

    @Inject
    public EclipseConstructorModelProvider(IModelRepository repository, IModelArchiveCoordinateAdvisor index, Map<String, IInputStreamTransformer> transformers) {
        this.repository = repository;
        this.index = index;
        this.transformers = transformers;
    }

    @PostConstruct
    public void open() throws IOException {
        this.delegate = new ConstructorModelProvider(this.repository, this.index, this.transformers);
        this.delegate.open();
    }

    @PreDestroy
    public void close() throws IOException {
        this.delegate.close();
    }

    public Optional<ConstructorModel> acquireModel(UniqueTypeName key) {
        return this.delegate.acquireModel((IUniqueName)key);
    }

    public void releaseModel(ConstructorModel value) {
        this.delegate.releaseModel((Object)value);
    }

    @Subscribe
    public void onEvent(ModelEvents.ModelRepositoryOpenedEvent e) throws IOException {
        this.open();
    }

    @Subscribe
    public void onEvent(ModelEvents.ModelRepositoryClosedEvent e) throws IOException {
        this.close();
    }
}

