/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.coordinates;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.IProjectCoordinateAdvisor;
import org.eclipse.recommenders.coordinates.IProjectCoordinateAdvisorService;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.utils.Result;

public class ProjectCoordinateAdvisorService
implements IProjectCoordinateAdvisorService {
    private List<IProjectCoordinateAdvisor> advisors = Lists.newArrayList();

    @Override
    public ImmutableList<IProjectCoordinateAdvisor> getAdvisors() {
        return ImmutableList.copyOf(this.advisors);
    }

    @Override
    public void addAdvisor(IProjectCoordinateAdvisor strategy) {
        this.advisors.add(strategy);
    }

    @Override
    public void setAdvisors(List<IProjectCoordinateAdvisor> strategies) {
        this.advisors = strategies;
    }

    @Override
    public Optional<ProjectCoordinate> suggest(DependencyInfo dependencyInfo) {
        for (IProjectCoordinateAdvisor a : this.advisors) {
            Optional<ProjectCoordinate> optionalProjectCoordinate = a.suggest(dependencyInfo);
            if (!optionalProjectCoordinate.isPresent()) continue;
            return optionalProjectCoordinate;
        }
        return Optional.absent();
    }

    @Override
    public Result<ProjectCoordinate> trySuggest(DependencyInfo dependencyInfo) {
        return Result.absent((int)1);
    }
}

