/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.IDependencyListener;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.injection.InjectionService;
import org.eclipse.recommenders.internal.models.rcp.l10n.Messages;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ProjectCoordinateSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "ProjectCoordinateSelectionDialog";
    private LabelProvider labelProvider;
    private final SharedImages images;
    private final IDependencyListener dependencyListener;
    private final IProjectCoordinateProvider pcAdvisor;

    public ProjectCoordinateSelectionDialog(Shell shell) {
        super(shell, true);
        this.setTitle(Messages.DIALOG_TITLE_SELECT_PROJECT_COORDINATE);
        this.images = (SharedImages)InjectionService.getInstance().requestInstance(SharedImages.class);
        this.dependencyListener = (IDependencyListener)InjectionService.getInstance().requestInstance(IDependencyListener.class);
        this.pcAdvisor = (IProjectCoordinateProvider)InjectionService.getInstance().requestInstance(IProjectCoordinateProvider.class);
        this.labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof ProjectCoordinate) {
                    return ProjectCoordinateSelectionDialog.this.createLabelForProjectCoordinate((ProjectCoordinate)element);
                }
                return element.toString();
            }

            public Image getImage(Object element) {
                if (element instanceof ProjectCoordinate) {
                    return ProjectCoordinateSelectionDialog.this.createImageForProjectCoordinate((ProjectCoordinate)element);
                }
                return super.getImage(element);
            }
        };
        this.setListLabelProvider((ILabelProvider)this.labelProvider);
        this.setDetailsLabelProvider((ILabelProvider)this.labelProvider);
    }

    public Image createImageForProjectCoordinate(ProjectCoordinate element) {
        return this.images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_JAR);
    }

    public String createLabelForProjectCoordinate(ProjectCoordinate element) {
        return element.toString();
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){

            public boolean matchItem(Object item) {
                if (item instanceof ProjectCoordinate && ProjectCoordinateSelectionDialog.this.filter((ProjectCoordinate)item)) {
                    return false;
                }
                return this.matches(item.toString());
            }

            public String getPattern() {
                String pattern = super.getPattern();
                if (pattern.equals("")) {
                    return "?";
                }
                return pattern;
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }
        };
    }

    public boolean filter(ProjectCoordinate pc) {
        return false;
    }

    protected Comparator<?> getItemsComparator() {
        return Ordering.usingToString();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
        ImmutableSet dependencies = this.dependencyListener.getDependencies();
        monitor.beginTask(Messages.DIALOG_RESOLVING_DEPENDENCIES, dependencies.size());
        try {
            for (DependencyInfo dependencyInfo : dependencies) {
                ProjectCoordinate pc = (ProjectCoordinate)this.pcAdvisor.resolve(dependencyInfo).orNull();
                if (pc != null) {
                    contentProvider.add((Object)pc, itemsFilter);
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    public String getElementName(Object item) {
        return this.labelProvider.getText(item);
    }

    public Set<ProjectCoordinate> getSelectedElements() {
        HashSet selectedElements = Sets.newHashSet();
        Object[] result = this.getResult();
        if (result != null) {
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof ProjectCoordinate) {
                    ProjectCoordinate pc = (ProjectCoordinate)object;
                    selectedElements.add(pc);
                }
                ++n2;
            }
        }
        return selectedElements;
    }
}

