/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.net;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.fluent.Executor;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;

public final class Proxies {
    private static final String DOUBLEBACKSLASH = "\\\\";
    private static final String ENV_USERDOMAIN = "USERDOMAIN";
    private static final String PROP_HTTP_AUTH_NTLM_DOMAIN = "http.auth.ntlm.domain";

    private Proxies() {
    }

    public static Optional<String> getUserDomain(String userName) {
        String domain = System.getProperty(PROP_HTTP_AUTH_NTLM_DOMAIN);
        if (domain != null) {
            return Optional.of((Object)domain);
        }
        domain = System.getenv(ENV_USERDOMAIN);
        if (domain != null) {
            return Optional.of((Object)domain);
        }
        if (StringUtils.contains((CharSequence)userName, (CharSequence)DOUBLEBACKSLASH)) {
            return Optional.of((Object)StringUtils.substringBefore((String)userName, (String)DOUBLEBACKSLASH));
        }
        return Optional.absent();
    }

    public static Optional<String> getWorkstation() {
        try {
            return Optional.of((Object)InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            return Optional.absent();
        }
    }

    public static Optional<String> getUserName(String userName) {
        if (userName == null) {
            return Optional.absent();
        }
        return StringUtils.contains((CharSequence)userName, (CharSequence)DOUBLEBACKSLASH) ? Optional.of((Object)StringUtils.substringAfterLast((String)userName, (String)DOUBLEBACKSLASH)) : Optional.of((Object)userName);
    }

    public static Optional<HttpHost> getProxyHost(URI target) {
        return Proxies.getProxyHost(ProxyManager.getProxyManager(), target);
    }

    @VisibleForTesting
    static Optional<HttpHost> getProxyHost(IProxyService proxyService, URI target) {
        IProxyData proxy = (IProxyData)Proxies.getProxyData(proxyService, target).orNull();
        if (proxy == null) {
            return Optional.absent();
        }
        return Optional.of((Object)new HttpHost(proxy.getHost(), proxy.getPort()));
    }

    public static Executor proxyAuthentication(Executor executor, URI target) throws IOException {
        return Proxies.proxyAuthentication(ProxyManager.getProxyManager(), executor, target);
    }

    @VisibleForTesting
    static Executor proxyAuthentication(IProxyService proxyService, Executor executor, URI target) throws IOException {
        IProxyData proxy = (IProxyData)Proxies.getProxyData(proxyService, target).orNull();
        if (proxy == null) {
            return executor;
        }
        String userId = proxy.getUserId();
        if (userId == null) {
            return executor;
        }
        String userName = (String)Proxies.getUserName(userId).orNull();
        String pass = proxy.getPassword();
        String workstation = (String)Proxies.getWorkstation().orNull();
        String domain = (String)Proxies.getUserDomain(userId).orNull();
        HttpHost proxyHost = new HttpHost(proxy.getHost(), proxy.getPort());
        return executor.auth(proxyHost, userName, pass, workstation, domain);
    }

    private static Optional<IProxyData> getProxyData(IProxyService service, URI target) {
        if (target == null || service == null) {
            return Optional.absent();
        }
        Object[] proxies = service.select(target);
        if (ArrayUtils.isEmpty((Object[])proxies)) {
            return Optional.absent();
        }
        return Optional.of((Object)proxies[0]);
    }
}

